/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.serial.jssc;

import java.io.IOException;
import java.io.OutputStream;
import jssc.SerialPort;
import jssc.SerialPortException;

public class SerialOutputStream
extends OutputStream {
    SerialPort serialPort;

    public SerialOutputStream(SerialPort sp) {
        this.serialPort = sp;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.serialPort.writeInt(b);
        }
        catch (SerialPortException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] buffer = new byte[len];
        System.arraycopy(b, off, buffer, 0, len);
        try {
            this.serialPort.writeBytes(buffer);
        }
        catch (SerialPortException e) {
            throw new IOException(e);
        }
    }
}

