/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.serial.jssc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.ardulink.core.Connection;
import org.ardulink.core.ConnectionBasedLink;
import org.ardulink.core.Link;
import org.ardulink.core.StreamConnection;
import org.ardulink.core.convenience.LinkDelegate;
import org.ardulink.core.linkmanager.LinkFactory;
import org.ardulink.core.qos.QosLink;
import org.ardulink.core.serial.jssc.SerialInputStream;
import org.ardulink.core.serial.jssc.SerialLinkConfig;
import org.ardulink.core.serial.jssc.SerialOutputStream;

public class SerialLinkFactory
implements LinkFactory<SerialLinkConfig> {
    protected static final String NAME = "serial-jssc";

    public String getName() {
        return NAME;
    }

    public LinkDelegate newLink(SerialLinkConfig config) throws SerialPortException, IOException {
        ConnectionBasedLink link;
        String portIdentifier = config.port;
        final SerialPort serialPort = this.serialPort(config, portIdentifier);
        ConnectionBasedLink connectionBasedLink = new ConnectionBasedLink((Connection)new StreamConnection((InputStream)new SerialInputStream(serialPort), (OutputStream)new SerialOutputStream(serialPort), config.protocol().newByteStreamProcessor()));
        Object object = link = config.qos ? new QosLink((Link)connectionBasedLink) : connectionBasedLink;
        if (!this.waitForArdulink(config, connectionBasedLink)) {
            connectionBasedLink.close();
            throw new IllegalStateException("Waited for arduino to boot but no response received");
        }
        return new LinkDelegate((Link)link){

            public void close() throws IOException {
                super.close();
                try {
                    serialPort.closePort();
                }
                catch (SerialPortException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private boolean waitForArdulink(SerialLinkConfig config, ConnectionBasedLink link) {
        if (config.pingprobe) {
            return link.waitForArduinoToBoot(config.waitsecs, TimeUnit.SECONDS);
        }
        try {
            TimeUnit.SECONDS.sleep(config.waitsecs);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private SerialPort serialPort(SerialLinkConfig config, String portIdentifier) throws SerialPortException {
        SerialPort serialPort = new SerialPort(portIdentifier);
        serialPort.openPort();
        serialPort.setParams(config.baudrate, 8, 1, 0);
        return serialPort;
    }

    public SerialLinkConfig newLinkConfig() {
        return new SerialLinkConfig();
    }
}

