/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.serial.jssc;

import java.util.List;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import jssc.SerialPortList;
import org.ardulink.core.linkmanager.LinkConfig;
import org.ardulink.core.proto.api.Protocol;
import org.ardulink.core.proto.api.Protocols;
import org.ardulink.util.Iterables;
import org.ardulink.util.Optionals;

@LinkConfig.I18n(value="message")
public class SerialLinkConfig
implements LinkConfig {
    private static final String NAMED_PROTO = "proto";
    private static final String NAMED_PORT = "port";
    @LinkConfig.Named(value="port")
    public String port;
    @LinkConfig.Named(value="baudrate")
    @Positive
    public int baudrate = 115200;
    private Protocol protocol = this.useProtoOrFallback("ardulink2");
    @LinkConfig.Named(value="qos")
    public boolean qos;
    @PositiveOrZero
    @Max(value=59L)
    @LinkConfig.Named(value="waitsecs")
    public @PositiveOrZero @Max(value=59L) int waitsecs = 10;
    @LinkConfig.Named(value="pingprobe")
    public boolean pingprobe = true;

    private Protocol useProtoOrFallback(String prefered) {
        return Optionals.or((Optional)Protocols.tryProtoByName((String)prefered), () -> Iterables.getFirst((Iterable)Protocols.protocols())).orElse(null);
    }

    @LinkConfig.ChoiceFor(value="port")
    public String[] listPorts() {
        return SerialPortList.getPortNames();
    }

    @LinkConfig.ChoiceFor(value="proto")
    public List<String> availableProtos() {
        return Protocols.protocolNames();
    }

    @LinkConfig.Named(value="proto")
    public String getProtoName() {
        return this.protocol == null ? null : this.protocol.getName();
    }

    @LinkConfig.Named(value="proto")
    public void setProtoName(String protoName) {
        this.protocol = Protocols.protoByName((String)protoName);
    }

    public Protocol protocol() {
        return this.protocol;
    }
}

