/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.serial.jssc;

import java.io.IOException;
import java.io.InputStream;
import jssc.SerialPort;

public class SerialInputStream
extends InputStream {
    private SerialPort serialPort;
    private int defaultTimeout = 0;

    public SerialInputStream(SerialPort sp) {
        this.serialPort = sp;
    }

    public void setTimeout(int time) {
        this.defaultTimeout = time;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.defaultTimeout);
    }

    public int read(int timeout) throws IOException {
        byte[] buf = new byte[1];
        try {
            buf = timeout > 0 ? this.serialPort.readBytes(1, timeout) : this.serialPort.readBytes(1);
            return buf[0];
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        int available;
        if (buf.length < offset + length) {
            length = buf.length - offset;
        }
        if ((available = this.available()) > length) {
            available = length;
        }
        try {
            byte[] readBuf = this.serialPort.readBytes(available);
            System.arraycopy(readBuf, 0, buf, offset, available);
            return readBuf.length;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int blockingRead(byte[] buf) throws IOException {
        return this.blockingRead(buf, 0, buf.length, this.defaultTimeout);
    }

    public int blockingRead(byte[] buf, int timeout) throws IOException {
        return this.blockingRead(buf, 0, buf.length, timeout);
    }

    public int blockingRead(byte[] buf, int offset, int length) throws IOException {
        return this.blockingRead(buf, offset, length, this.defaultTimeout);
    }

    public int blockingRead(byte[] buf, int offset, int length, int timeout) throws IOException {
        if (buf.length < offset + length) {
            throw new IOException("Not enough buffer space for serial data");
        }
        if (timeout < 1) {
            return this.read(buf, offset, length);
        }
        try {
            byte[] readBuf = this.serialPort.readBytes(length, timeout);
            System.arraycopy(readBuf, 0, buf, offset, length);
            return readBuf.length;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            int ret = this.serialPort.getInputBufferBytesCount();
            if (ret >= 0) {
                return ret;
            }
            throw new IOException("Error checking available bytes from the serial port.");
        }
        catch (Exception e) {
            throw new IOException("Error checking available bytes from the serial port.");
        }
    }
}

