/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.bluetooth;

import java.io.IOException;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnectionNotifier;
import org.ardulink.core.ByteStreamProcessorProvider;
import org.ardulink.core.Connection;
import org.ardulink.core.ConnectionBasedLink;
import org.ardulink.core.StreamConnection;
import org.ardulink.core.bluetooth.BluetoothDiscoveryUtil;
import org.ardulink.core.bluetooth.BluetoothLinkConfig;
import org.ardulink.core.linkmanager.LinkFactory;
import org.ardulink.core.proto.api.Protocols;
import org.ardulink.util.Preconditions;

public class BluetoothLinkFactory
implements LinkFactory<BluetoothLinkConfig> {
    public String getName() {
        return "bluetooth";
    }

    public ConnectionBasedLink newLink(BluetoothLinkConfig config) throws IOException {
        String url = this.getURL(config);
        Preconditions.checkState((url != null ? 1 : 0) != 0, (String)"The connection could not be made. Connection url not found", (Object[])new Object[0]);
        javax.microedition.io.StreamConnection streamConnection = this.getStreamConnection(Connector.open((String)url));
        return new ConnectionBasedLink((Connection)new StreamConnection(streamConnection.openInputStream(), streamConnection.openOutputStream(), Protocols.protoByName((String)"ardulink2").newByteStreamProcessor()));
    }

    public String getURL(BluetoothLinkConfig config) {
        return this.getServiceRecord(config).getConnectionURL(0, false);
    }

    public ServiceRecord getServiceRecord(BluetoothLinkConfig config) {
        ServiceRecord serviceRecord = BluetoothDiscoveryUtil.getDevices().get(config.getDeviceName());
        Preconditions.checkState((serviceRecord != null ? 1 : 0) != 0, (String)"The connection could not be made. Device not discovered", (Object[])new Object[0]);
        return serviceRecord;
    }

    public javax.microedition.io.StreamConnection getStreamConnection(javax.microedition.io.Connection connection) throws IOException {
        if (connection instanceof StreamConnectionNotifier) {
            return ((StreamConnectionNotifier)connection).acceptAndOpen();
        }
        if (connection instanceof ByteStreamProcessorProvider) {
            return (javax.microedition.io.StreamConnection)connection;
        }
        throw new IllegalStateException("Connection class not known. " + connection.getClass().getName());
    }

    public BluetoothLinkConfig newLinkConfig() {
        return new BluetoothLinkConfig();
    }
}

