/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.bluetooth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import org.ardulink.util.Maps;
import org.ardulink.util.Throwables;

public final class BluetoothDiscoveryUtil {
    private static final int SERVICE_NAME = 256;
    private static final UUID SERIAL_PORT_SERVICE = new UUID(4353L);

    private BluetoothDiscoveryUtil() {
    }

    public static Map<String, ServiceRecord> getDevices() {
        Semaphore semaphore = new Semaphore(0);
        ArrayList<RemoteDevice> devices = new ArrayList<RemoteDevice>();
        HashMap<String, ServiceRecord> ports = new HashMap<String, ServiceRecord>();
        DiscoveryListener listener = BluetoothDiscoveryUtil.listener(devices, ports, semaphore);
        DiscoveryAgent agent = BluetoothDiscoveryUtil.getLocalDevice().getDiscoveryAgent();
        try {
            agent.startInquiry(10390323, listener);
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (BluetoothStateException e) {
            throw Throwables.propagate((Throwable)e);
        }
        for (RemoteDevice device : devices) {
            try {
                agent.searchServices(BluetoothDiscoveryUtil.serviceName(), BluetoothDiscoveryUtil.serialPortService(), device, listener);
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (BluetoothStateException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return ports;
    }

    private static DiscoveryListener listener(final List<RemoteDevice> devices, final Map<String, ServiceRecord> ports, final Semaphore semaphore) {
        return new DiscoveryListener(){
            private final Map<RemoteDevice, ServiceRecord[]> services = new HashMap<RemoteDevice, ServiceRecord[]>();

            public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
                devices.add(remoteDevice);
            }

            public void inquiryCompleted(int discType) {
                semaphore.release();
            }

            public void serviceSearchCompleted(int transID, int respCode) {
                this.services.entrySet().stream().map(e -> Maps.entry((Object)this.getName((RemoteDevice)e.getKey()), (Object)this.findService((ServiceRecord[])e.getValue()))).filter(e -> e.getValue() != null).forEach(e -> ports.put((String)e.getKey(), (ServiceRecord)e.getValue()));
                semaphore.release();
            }

            public String getName(RemoteDevice remoteDevice) {
                return this.getFriendlyName(remoteDevice) + " " + remoteDevice.getBluetoothAddress();
            }

            public String getFriendlyName(RemoteDevice remoteDevice) {
                try {
                    return remoteDevice.getFriendlyName(false);
                }
                catch (IOException e) {
                    return "noname";
                }
            }

            private ServiceRecord findService(ServiceRecord[] serviceRecords) {
                return serviceRecords.length == 1 ? serviceRecords[0] : (ServiceRecord)Arrays.stream(serviceRecords).filter(r -> this.isDevB((ServiceRecord)r)).findFirst().orElse(null);
            }

            private boolean isDevB(ServiceRecord serviceRecords) {
                return Optional.ofNullable(serviceRecords.getAttributeValue(256)).map(DataElement::getValue).filter(Predicate.isEqual("DevB")).isPresent();
            }

            public void servicesDiscovered(int transID, ServiceRecord[] serviceRecords) {
                Arrays.stream(serviceRecords).forEach(r -> this.services.put(r.getHostDevice(), serviceRecords));
            }
        };
    }

    private static LocalDevice getLocalDevice() {
        try {
            return LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static int[] serviceName() {
        return new int[]{256};
    }

    private static UUID[] serialPortService() {
        return new UUID[]{SERIAL_PORT_SERVICE};
    }
}

