/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.archive.util.Histotable;

public class TopNSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int maxsize;
    protected ConcurrentMap<String, Long> set;
    protected volatile long smallestKnownValue;
    protected volatile String smallestKnownKey;
    protected volatile long largestKnownValue;
    protected volatile String largestKnownKey;

    public TopNSet(int size) {
        this.maxsize = size;
        this.set = CacheBuilder.newBuilder().concurrencyLevel(64).build().asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String key, long value) {
        if (this.set.size() < this.maxsize) {
            this.set.put(key, value);
            this.updateBounds();
            return;
        }
        if (value < this.smallestKnownValue && !this.set.containsKey(key)) {
            return;
        }
        this.set.put(key, value);
        TopNSet topNSet = this;
        synchronized (topNSet) {
            if (this.set.size() > this.maxsize) {
                this.set.remove(this.smallestKnownKey);
                this.updateBounds();
            } else if (value < this.smallestKnownValue || value > this.largestKnownValue || key.equals(this.smallestKnownKey) || key.equals(this.largestKnownKey)) {
                this.updateBounds();
            }
        }
    }

    public String getLargest() {
        return this.largestKnownKey;
    }

    public String getSmallest() {
        return this.smallestKnownKey;
    }

    public synchronized void updateBounds() {
        this.smallestKnownValue = Long.MAX_VALUE;
        this.largestKnownValue = Long.MIN_VALUE;
        for (String k : this.set.keySet()) {
            long v = (Long)this.set.get(k);
            if (v < this.smallestKnownValue) {
                this.smallestKnownValue = v;
                this.smallestKnownKey = k;
            }
            if (v <= this.largestKnownValue) continue;
            this.largestKnownValue = v;
            this.largestKnownKey = k;
        }
    }

    public ConcurrentMap<String, Long> getTopSet() {
        return this.set;
    }

    public int size() {
        return this.set.size();
    }

    public SortedSet<Map.Entry<?, Long>> getEntriesDescending() {
        TreeSet sorted = Histotable.getEntryByFrequencySortedSet();
        sorted.addAll(this.getTopSet().entrySet());
        return sorted;
    }

    public int getMaxSize() {
        return this.maxsize;
    }

    public void setMaxSize(int max) {
        this.maxsize = max;
    }
}

