/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.Serializable;
import java.util.logging.Logger;
import org.archive.crawler.util.SetBasedUriUniqFilter;
import org.archive.modules.CrawlURI;
import org.archive.util.BloomFilter;
import org.archive.util.BloomFilter64bit;
import org.springframework.beans.factory.InitializingBean;

public class BloomUriUniqFilter
extends SetBasedUriUniqFilter
implements Serializable,
InitializingBean {
    private static final long serialVersionUID = 1061526253773091309L;
    private static Logger LOGGER = Logger.getLogger(BloomUriUniqFilter.class.getName());
    protected BloomFilter bloom;

    public BloomFilter getBloomFilter() {
        return this.bloom;
    }

    public void setBloomFilter(BloomFilter filter) {
        this.bloom = filter;
    }

    public void afterPropertiesSet() {
        if (this.bloom == null) {
            this.bloom = new BloomFilter64bit(125000000L, 22);
        }
    }

    @Override
    public void forget(String canonical, CrawlURI item) {
        LOGGER.severe("forget(\"" + canonical + "\",CrawlURI) not supported");
    }

    @Override
    protected boolean setAdd(CharSequence uri) {
        boolean added = this.bloom.add(uri);
        if (added && this.count() == this.bloom.getExpectedInserts()) {
            LOGGER.warning("Bloom has reached expected limit " + this.bloom.getExpectedInserts() + "; false-positive rate will now rise above goal of 1-in-(2^" + this.bloom.getHashCount());
        }
        return added;
    }

    @Override
    protected long setCount() {
        return this.bloom.size();
    }

    @Override
    protected boolean setRemove(CharSequence uri) {
        throw new UnsupportedOperationException();
    }
}

