/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.bdb.BdbModule;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.crawler.util.SetBasedUriUniqFilter;
import org.archive.util.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;
import st.ata.util.FPGenerator;

public class BdbUriUniqFilter
extends SetBasedUriUniqFilter
implements Lifecycle,
Checkpointable,
BeanNameAware,
DisposableBean {
    private static final long serialVersionUID = -8099357538178524011L;
    private static Logger logger = Logger.getLogger(BdbUriUniqFilter.class.getName());
    protected boolean createdEnvironment = false;
    protected long lastCacheMiss = 0L;
    protected long lastCacheMissDiff = 0L;
    protected transient Database alreadySeen = null;
    protected transient DatabaseEntry value = null;
    protected static DatabaseEntry ZERO_LENGTH_ENTRY = new DatabaseEntry(new byte[0]);
    private static final String DB_NAME = "alreadySeenUrl";
    protected AtomicLong count = new AtomicLong(0L);
    private long aggregatedLookupTime = 0L;
    private static final String COLON_SLASH_SLASH = "://";
    protected BdbModule bdb;
    protected String beanName;
    protected boolean isRunning = false;
    protected Checkpoint recoveryCheckpoint;

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public BdbUriUniqFilter() {
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        boolean isRecovery = this.recoveryCheckpoint != null;
        try {
            BdbModule.BdbConfig config = this.getDatabaseConfig();
            config.setAllowCreate(!isRecovery);
            this.initialize(this.bdb.openDatabase(DB_NAME, config, isRecovery));
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
        if (isRecovery) {
            JSONObject json = this.recoveryCheckpoint.loadJson(this.beanName);
            try {
                this.count.set(json.getLong("count"));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.isRunning = false;
    }

    public void destroy() {
        this.close();
    }

    public BdbUriUniqFilter(File bdbEnv) throws IOException {
        this(bdbEnv, -1);
    }

    public BdbUriUniqFilter(File bdbEnv, int cacheSizePercentage) throws IOException {
        FileUtils.ensureWriteableDirectory((File)bdbEnv);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        if (cacheSizePercentage > 0 && cacheSizePercentage < 100) {
            envConfig.setCachePercent(cacheSizePercentage);
        }
        try {
            this.createdEnvironment = true;
            Environment env = new Environment(bdbEnv, envConfig);
            BdbModule.BdbConfig config = this.getDatabaseConfig();
            config.setAllowCreate(true);
            try {
                env.truncateDatabase(null, DB_NAME, false);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                // empty catch block
            }
            Database db = env.openDatabase(null, DB_NAME, config.toDatabaseConfig());
            this.initialize(db);
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    protected void initialize(Database db) throws DatabaseException {
        this.open(db);
    }

    protected BdbModule.BdbConfig getDatabaseConfig() {
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        return dbConfig;
    }

    public void reopen(Database db) throws DatabaseException {
        this.open(db);
    }

    protected void open(Database db) throws DatabaseException {
        this.alreadySeen = db;
        this.value = new DatabaseEntry("".getBytes());
    }

    @Override
    public synchronized void close() {
        logger.fine("Count of alreadyseen on close " + this.count.get());
        Environment env = null;
        if (this.alreadySeen != null) {
            try {
                env = this.alreadySeen.getEnvironment();
                this.alreadySeen.sync();
            }
            catch (DatabaseException e) {
                logger.severe(e.getMessage());
            }
        }
        if (env != null) {
            try {
                env.sync();
            }
            catch (DatabaseException e) {
                logger.severe(e.getMessage());
            }
        }
        if (this.createdEnvironment) {
            if (this.alreadySeen != null) {
                try {
                    this.alreadySeen.close();
                }
                catch (DatabaseException e) {
                    logger.severe(e.getMessage());
                }
            }
            if (env != null) {
                try {
                    env.close();
                }
                catch (DatabaseException e) {
                    logger.severe(e.getMessage());
                }
            }
        }
    }

    public synchronized long getCacheMisses() {
        if (this.alreadySeen == null) {
            return 0L;
        }
        try {
            long cacheMiss = this.alreadySeen.getEnvironment().getStats(null).getNCacheMiss();
            this.lastCacheMissDiff = cacheMiss - this.lastCacheMiss;
            this.lastCacheMiss = cacheMiss;
            return this.lastCacheMiss;
        }
        catch (DatabaseException de) {
            return 0L;
        }
    }

    public long getLastCacheMissDiff() {
        return this.lastCacheMissDiff;
    }

    public static long createKey(CharSequence uri) {
        String url = uri.toString();
        long schemeAuthorityKeyPart = BdbUriUniqFilter.calcSchemeAuthorityKeyBytes(url);
        return schemeAuthorityKeyPart | FPGenerator.std40.fp((CharSequence)url) >>> 24;
    }

    protected static long calcSchemeAuthorityKeyBytes(String url) {
        int index = url.indexOf(COLON_SLASH_SLASH);
        if (index > 0) {
            index = url.indexOf(47, index + COLON_SLASH_SLASH.length());
        }
        String schemeAuthority = index == -1 ? url : url.subSequence(0, index);
        return FPGenerator.std24.fp((CharSequence)schemeAuthority);
    }

    @Override
    protected boolean setAdd(CharSequence uri) {
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)BdbUriUniqFilter.createKey(uri), (DatabaseEntry)key);
        long started = 0L;
        OperationStatus status = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                started = System.currentTimeMillis();
            }
            status = this.alreadySeen.putNoOverwrite(null, key, ZERO_LENGTH_ENTRY);
            if (logger.isLoggable(Level.FINE)) {
                this.aggregatedLookupTime += System.currentTimeMillis() - started;
            }
        }
        catch (DatabaseException e) {
            logger.severe(e.getMessage());
        }
        if (status == OperationStatus.SUCCESS) {
            this.count.incrementAndGet();
            if (logger.isLoggable(Level.FINE)) {
                int logAt = 10000;
                if (this.count.get() > 0L && this.count.get() % 10000L == 0L) {
                    logger.fine("Average lookup " + this.aggregatedLookupTime / 10000L + "ms.");
                    this.aggregatedLookupTime = 0L;
                }
            }
        }
        return status != OperationStatus.KEYEXIST;
    }

    @Override
    protected long setCount() {
        return this.count.get();
    }

    @Override
    protected boolean setRemove(CharSequence uri) {
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)BdbUriUniqFilter.createKey(uri), (DatabaseEntry)key);
        OperationStatus status = null;
        try {
            status = this.alreadySeen.delete(null, key);
        }
        catch (DatabaseException e) {
            logger.severe(e.getMessage());
        }
        if (status == OperationStatus.SUCCESS) {
            this.count.decrementAndGet();
            return true;
        }
        return false;
    }

    public long flush() {
        return 0L;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        JSONObject json = new JSONObject();
        try {
            json.put("count", this.setCount());
            checkpointInProgress.saveJson(this.beanName, json);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void setRecoveryCheckpoint(Checkpoint recoveryCheckpoint) {
        this.recoveryCheckpoint = recoveryCheckpoint;
    }

    public void forgetAllSchemeAuthorityMatching(String url) {
        byte[] keyData;
        long schemeAuthorityKeyLong = BdbUriUniqFilter.calcSchemeAuthorityKeyBytes(url);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        LongBinding.longToEntry((long)schemeAuthorityKeyLong, (DatabaseEntry)key);
        byte[] schemeAuthorityKeyBytes = key.getData();
        Cursor cursor = this.alreadySeen.openCursor(null, null);
        long forgottenCount = 0L;
        OperationStatus status = cursor.getSearchKeyRange(key, value, null);
        while (status == OperationStatus.SUCCESS && (keyData = key.getData())[0] == schemeAuthorityKeyBytes[0] && keyData[1] == schemeAuthorityKeyBytes[1] && keyData[2] == schemeAuthorityKeyBytes[2]) {
            cursor.delete();
            ++forgottenCount;
            status = cursor.getNext(key, value, null);
        }
        cursor.close();
        long newCount = this.count.addAndGet(-forgottenCount);
        logger.info("forgot " + forgottenCount + " urls from scheme+authority of url " + url + " (leaving " + newCount + " urls from other scheme+authorities)");
    }
}

