/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet.models;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.archive.crawler.restlet.ScriptingConsole;

@XmlRootElement(name="script")
@XmlType(propOrder={"crawlJobUrl", "crawlJobShortName", "availableScriptEngines", "script", "linesExecuted", "exception", "rawOutput", "htmlOutput", "availableGlobalVariables"})
public class ScriptModel {
    private String crawlJobUrl;
    private Collection<Map<String, String>> availableScriptEngines;
    private ScriptingConsole scriptingConsole;

    public ScriptModel(ScriptingConsole cc, String crawlJobUrl, Collection<Map<String, String>> scriptEngines) {
        this.scriptingConsole = cc;
        this.crawlJobUrl = crawlJobUrl;
        this.availableScriptEngines = scriptEngines;
    }

    public boolean isFailure() {
        return this.scriptingConsole.getException() != null;
    }

    public String getStackTrace() {
        Throwable exception = this.scriptingConsole.getException();
        if (exception == null) {
            return "";
        }
        StringWriter s = new StringWriter();
        exception.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public Throwable getException() {
        return this.scriptingConsole.getException();
    }

    public int getLinesExecuted() {
        return this.scriptingConsole.getLinesExecuted();
    }

    public String getRawOutput() {
        return this.scriptingConsole.getRawOutput();
    }

    public String getHtmlOutput() {
        return this.scriptingConsole.getHtmlOutput();
    }

    public String getScript() {
        return this.scriptingConsole.getScript();
    }

    public String getCrawlJobShortName() {
        return this.scriptingConsole.getCrawlJob().getShortName();
    }

    public Collection<Map<String, String>> getAvailableScriptEngines() {
        return this.availableScriptEngines;
    }

    public List<Map<String, String>> getAvailableGlobalVariables() {
        return this.scriptingConsole.getAvailableGlobalVariables();
    }

    public String getCrawlJobUrl() {
        return this.crawlJobUrl;
    }
}

