/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet.models;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.CrawlJob;
import org.archive.crawler.framework.Engine;
import org.archive.util.FileUtils;

public class EngineModel
extends LinkedHashMap<String, Object> {
    public EngineModel(Engine engine, String urlBaseRef) {
        this.put("heritrixVersion", engine.getHeritrixVersion());
        this.put("heapReport", engine.heapReportData());
        this.put("jobsDir", FileUtils.tryToCanonicalize((File)engine.getJobsDir()).getAbsolutePath());
        this.put("jobsDirUrl", urlBaseRef + "jobsdir/");
        LinkedList<String> actions = new LinkedList<String>();
        actions.add("rescan");
        actions.add("add");
        actions.add("create");
        this.put("availableActions", actions);
        this.put("jobs", this.makeJobList(engine, urlBaseRef));
    }

    private List<Map<String, Object>> makeJobList(Engine engine, String urlBaseRef) {
        ArrayList<Map<String, Object>> jobList = new ArrayList<Map<String, Object>>();
        ArrayList<Map.Entry<String, CrawlJob>> jobConfigurations = new ArrayList<Map.Entry<String, CrawlJob>>(engine.getJobConfigs().entrySet());
        Collections.sort(jobConfigurations, new Comparator<Map.Entry<String, CrawlJob>>(){

            @Override
            public int compare(Map.Entry<String, CrawlJob> cj1, Map.Entry<String, CrawlJob> cj2) {
                return cj1.getValue().compareTo(cj2.getValue());
            }
        });
        for (Map.Entry<String, CrawlJob> jobConfig : jobConfigurations) {
            CrawlJob job = jobConfig.getValue();
            LinkedHashMap<String, Object> crawlJobModel = new LinkedHashMap<String, Object>();
            crawlJobModel.put("shortName", job.getShortName());
            crawlJobModel.put("url", urlBaseRef + "job/" + job.getShortName());
            crawlJobModel.put("isProfile", job.isProfile());
            crawlJobModel.put("launchCount", job.getLaunchCount());
            crawlJobModel.put("lastLaunch", job.getLastLaunch());
            crawlJobModel.put("hasApplicationContext", job.hasApplicationContext());
            crawlJobModel.put("statusDescription", job.getJobStatusDescription());
            crawlJobModel.put("isLaunchInfoPartial", job.isLaunchInfoPartial());
            File primaryConfig = FileUtils.tryToCanonicalize((File)job.getPrimaryConfig());
            crawlJobModel.put("primaryConfig", primaryConfig.getAbsolutePath());
            crawlJobModel.put("primaryConfigUrl", urlBaseRef + "jobdir/" + primaryConfig.getName());
            if (job.getCrawlController() != null) {
                crawlJobModel.put("crawlControllerState", job.getCrawlController().getState());
                if (job.getCrawlController().getState() == CrawlController.State.FINISHED) {
                    crawlJobModel.put("crawlExitStatus", (Object)job.getCrawlController().getCrawlExitStatus());
                }
            }
            crawlJobModel.put("key", jobConfig.getKey());
            jobList.add(crawlJobModel);
        }
        return jobList;
    }
}

