/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.LongRange;
import org.archive.crawler.restlet.EnhDirectoryResource;
import org.archive.modules.fetcher.FetchStatusCodes;
import org.archive.util.FileUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.representation.CharacterRepresentation;
import org.restlet.representation.FileRepresentation;

public class PagedRepresentation
extends CharacterRepresentation {
    protected FileRepresentation fileRepresentation;
    protected EnhDirectoryResource dirResource;
    protected long position;
    protected int lineCount;
    protected boolean reversedOrder;
    protected List<String> lines;
    protected LongRange range;
    protected File file;
    private static final Map<Integer, String> FETCH_STATUS_NAMES = new HashMap<Integer, String>();
    private static final Pattern CRAWL_LOG_PATTERN;

    public PagedRepresentation(FileRepresentation representation, EnhDirectoryResource resource, String pos, String lines, String reverse) {
        super(MediaType.TEXT_HTML);
        this.fileRepresentation = representation;
        this.dirResource = resource;
        this.position = StringUtils.isBlank((String)pos) ? 0L : Long.parseLong(pos);
        this.lineCount = StringUtils.isBlank((String)lines) ? 128 : Integer.parseInt(lines);
        this.reversedOrder = "y".equals(reverse);
        this.setCharacterSet(CharacterSet.UTF_8);
    }

    public Reader getReader() throws IOException {
        int estimatedSize = Math.abs(this.lineCount) * 128 + 500;
        StringWriter writer = new StringWriter(estimatedSize);
        this.write(writer);
        return new StringReader(writer.toString());
    }

    protected void loadLines() throws IOException {
        this.file = this.fileRepresentation.getFile();
        this.lines = new LinkedList<String>();
        this.range = FileUtils.pagedLines((File)this.file, (long)this.position, (int)this.lineCount, this.lines, (int)128);
        if (this.lines.size() < Math.abs(this.lineCount) && this.range.getMinimumLong() == 0L && this.range.getMaximumLong() < this.file.length()) {
            this.lines = new LinkedList<String>();
            this.range = FileUtils.pagedLines((File)this.file, (long)0L, (int)Math.abs(this.lineCount), this.lines, (int)128);
        }
        if (this.reversedOrder) {
            Collections.reverse(this.lines);
        }
    }

    public void write(Writer writer) throws IOException {
        this.loadLines();
        PrintWriter pw = new PrintWriter(writer);
        pw.println("<b>Paged view:</b> " + this.file);
        this.emitControls(pw);
        Function<Object, Object> syntaxHighlighter = Function.identity();
        if (this.file.getName().equals("crawl.log")) {
            pw.println("<style>\n.status-neg { color: #777; }\n.status-2xx { color: #070; }\n.status-3xx { color: #007; }\n.status-4xx { color: #770; }\n.status-5xx { color: #770; }\n</style>");
            syntaxHighlighter = this::highlightCrawlLogLine;
        }
        pw.println("<pre>");
        this.emitBumper(pw, true);
        for (String line : this.lines) {
            pw.println((String)syntaxHighlighter.apply(StringEscapeUtils.escapeHtml((String)line)));
        }
        this.emitBumper(pw, false);
        pw.println("</pre>");
        this.emitControls(pw);
    }

    public String highlightCrawlLogLine(String line) {
        Matcher m = CRAWL_LOG_PATTERN.matcher(line);
        if (m.matches()) {
            String date = m.group(1);
            String status = m.group(2);
            String rest = m.group(3);
            int code = Integer.parseInt(status);
            String clazz = "";
            if (code < 0) {
                clazz = "status-neg";
            } else if (code >= 200 && code <= 299) {
                clazz = "status-2xx";
            } else if (code >= 300 && code <= 399) {
                clazz = "status-3xx";
            } else if (code >= 400 && code <= 499) {
                clazz = "status-4xx";
            } else if (code >= 500 && code <= 599) {
                clazz = "status-5xx";
            }
            String reason = FETCH_STATUS_NAMES.get(code);
            if (reason == null) {
                reason = HttpStatus.getMessage((int)code);
            }
            return date + "<abbr class='" + clazz + "' title='" + reason + "'>" + status + "</abbr>" + rest;
        }
        return line;
    }

    protected void emitBumper(PrintWriter pw, boolean atTop) {
        if (!this.reversedOrder ^ atTop && this.range.getMaximumLong() == this.file.length()) {
            pw.println("<span class='endBumper' style='font-weight:bold; color:white; background-color:#400'>&laquo;EOF&raquo;</span>");
            return;
        }
        if (this.reversedOrder ^ atTop && this.range.getMinimumLong() == 0L) {
            pw.println("<span class='startBumper' style='font-weight:bold; color:white; background-color:#040'>&laquo;START&raquo;</span>");
        }
    }

    protected void emitControls(PrintWriter pw) {
        pw.println("<table id='controls' width='100%'><tr>");
        if (this.reversedOrder) {
            pw.print("<td style='text-align:left'>");
            pw.print("<a href='");
            pw.print(this.getControlUri(-1L, -Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>&laquo; end</a>");
            pw.print("<a href='");
            pw.print(this.getControlUri(Math.min(this.file.length() - 1L, this.range.getMaximumLong()), Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>&lsaquo; later</a>");
            pw.println("bytes " + this.range.getMaximumLong() + "-" + this.range.getMinimumLong() + "/" + this.file.length() + " " + (int)(100.0f * ((float)this.range.getMaximumLong() / (float)this.file.length())) + "%");
            pw.print("<a href='");
            pw.print(this.getControlUri(Math.max(0L, this.range.getMinimumLong() - 1L), -Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>earlier &rsaquo;</a>");
            pw.print("<a href='");
            pw.print(this.getControlUri(0L, Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>start &raquo;</a>");
            pw.println("</td>");
            pw.println("<td style='text-align:right'>");
            pw.println("<a href='" + this.getControlUri(this.position, this.lineCount, false) + "'>forward</a>");
            pw.println("| <b>reversed</b>");
        } else {
            pw.print("<td style='text-align:left'>");
            pw.print("<a href='");
            pw.print(this.getControlUri(0L, Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>&laquo; start</a>");
            pw.print("<a href='");
            pw.print(this.getControlUri(Math.max(0L, this.range.getMinimumLong() - 1L), -Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>&lsaquo; earlier</a>");
            pw.println("bytes " + this.range.getMinimumLong() + "-" + this.range.getMaximumLong() + "/" + this.file.length() + " " + (int)(100.0f * ((float)this.range.getMaximumLong() / (float)this.file.length())) + "%");
            pw.print("<a href='");
            pw.print(this.getControlUri(Math.min(this.file.length() - 1L, this.range.getMaximumLong()), Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>later &rsaquo;</a>");
            pw.print("<a href='");
            pw.print(this.getControlUri(this.file.length(), -Math.abs(this.lineCount), this.reversedOrder));
            pw.println("'>end &raquo;</a>");
            pw.println("</td>");
            pw.println("<td style='text-align:right'><b>forward</b>");
            pw.println("| <a href='" + this.getControlUri(this.position, this.lineCount, true) + "'>reversed</a>");
        }
        pw.print("<a href='");
        pw.println(this.getControlUri(this.position, this.lineCount * 2, this.reversedOrder));
        pw.println("'>&nbsp;+&nbsp;</a>");
        pw.println(this.lines.size());
        pw.print("<a href='" + this.getControlUri(this.position, this.lineCount / 2, this.reversedOrder));
        pw.println("'>&nbsp;-&nbsp;</a> lines</td>");
        pw.println("</tr></table>");
    }

    protected String getControlUri(long pos, int lines, boolean reverse) {
        Form query = new Form();
        query.add("format", "paged");
        if (pos != 0L) {
            query.add("pos", Long.toString(pos));
        }
        if (lines != 128) {
            if (Math.abs(lines) < 1) {
                lines = 1;
            }
            query.add("lines", Integer.toString(lines));
        }
        if (reverse) {
            query.add("reverse", "y");
        }
        Reference viewRef = this.dirResource.getRequest().getOriginalRef().clone();
        viewRef.setQuery(query.getQueryString());
        return viewRef.toString();
    }

    static {
        for (Field field : FetchStatusCodes.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE)) continue;
            try {
                FETCH_STATUS_NAMES.put((Integer)field.get(null), field.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        CRAWL_LOG_PATTERN = Pattern.compile("([^ ]+ +)(-?[0-9]+)( +.*)");
    }
}

