/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.framework.CrawlJob;
import org.archive.crawler.restlet.BaseResource;
import org.archive.crawler.restlet.DescriptorUpdater;
import org.archive.util.TextUtils;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.resource.ResourceException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;

public abstract class JobRelatedResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(JobRelatedResource.class.getName());
    protected CrawlJob cj;
    protected IdentityHashMap<Object, String> beanToNameMap;
    protected static HashSet<String> HIDDEN_PROPS = new HashSet<String>(Arrays.asList("class", "declaringClass", "keyedProperties", "running", "first", "last", "empty", "inbound", "outbound", "cookiesMap"));

    public void init(Context ctx, Request req, Response res) {
        super.init(ctx, req, res);
        this.cj = this.getEngine().getJob((String)req.getAttributes().get("job"));
        if (this.cj == null) {
            throw new ResourceException(404);
        }
    }

    protected void addPresentableNestedNames(Collection<Object> namedBeans, Object obj, Set<Object> alreadyWritten) {
        if (obj == null || obj instanceof Optional && !((Optional)obj).isPresent() || obj instanceof Class || alreadyWritten.contains(obj) || obj.getClass().getName().startsWith("org.springframework.")) {
            return;
        }
        Reference baseRef = this.getRequest().getResourceRef().getBaseRef();
        if (baseRef.getPath().endsWith("beans")) {
            baseRef.setPath(baseRef.getPath() + "/");
        }
        if (this.getBeanToNameMap().containsKey(obj)) {
            LinkedHashMap<String, Object> bean = new LinkedHashMap<String, Object>();
            bean.put("name", this.getBeanToNameMap().get(obj));
            bean.put("url", new Reference(baseRef, "../beans/" + this.getBeanToNameMap().get(obj)).getTargetRef());
            bean.put("class", obj.getClass().getName());
            namedBeans.add(bean);
            namedBeans = new LinkedList<Object>();
            bean.put("children", namedBeans);
        }
        boolean writtenBefore = false;
        try {
            writtenBefore = alreadyWritten.contains(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!writtenBefore) {
            alreadyWritten.add(obj);
            BeanWrapperImpl bwrap = new BeanWrapperImpl(obj);
            for (PropertyDescriptor pd : this.getPropertyDescriptors(bwrap)) {
                if (pd.getReadMethod() == null) continue;
                String propName = pd.getName();
                try {
                    Object propValue = bwrap.getPropertyValue(propName);
                    this.addPresentableNestedNames(namedBeans, propValue, alreadyWritten);
                }
                catch (BeansException beansException) {
                    // empty catch block
                }
            }
            if (obj.getClass().isArray()) {
                List<Object> list = Arrays.asList(obj);
                for (int i = 0; i < list.size(); ++i) {
                    this.addPresentableNestedNames(namedBeans, list.get(i), alreadyWritten);
                }
            }
            if (obj instanceof Iterable) {
                try {
                    for (Object next : (Iterable)obj) {
                        this.addPresentableNestedNames(namedBeans, next, alreadyWritten);
                    }
                }
                catch (Exception e) {
                    LOGGER.warning("problem iterating over " + obj + " - " + e);
                }
            }
        }
    }

    protected Map<String, Object> makePresentableMapFor(String field, Object object) {
        return this.makePresentableMapFor(field, object, new HashSet<Object>(), null);
    }

    protected Map<String, Object> makePresentableMapFor(String field, Object object, String beanPath) {
        return this.makePresentableMapFor(field, object, new HashSet<Object>(), beanPath);
    }

    protected Map<String, Object> makePresentableMapFor(String field, Object object, HashSet<Object> alreadyWritten, String beanPathPrefix) {
        int i;
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        Reference baseRef = this.getRequest().getResourceRef().getBaseRef();
        String beanPath = beanPathPrefix;
        if (StringUtils.isNotBlank((String)field)) {
            info.put("field", field);
            if (StringUtils.isNotBlank((String)beanPathPrefix)) {
                if (beanPathPrefix.endsWith(".")) {
                    beanPath = beanPath + field;
                } else if (beanPathPrefix.endsWith("[")) {
                    beanPath = beanPath + field + "]";
                }
                info.put("url", new Reference(baseRef, "../beans/" + TextUtils.urlEscape((String)beanPath)).getTargetRef());
            }
        }
        String key = this.getBeanToNameMap().get(object);
        if (object == null) {
            info.put("propValue", null);
            return info;
        }
        if (object instanceof String || BeanUtils.isSimpleValueType(object.getClass()) || object instanceof File) {
            info.put("class", object.getClass().getName());
            info.put("propValue", object);
            return info;
        }
        if (alreadyWritten.contains(object)) {
            info.put("propValuePreviouslyDescribed", true);
            return info;
        }
        alreadyWritten.add(object);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)field)) {
            info.put("key", key);
            info.put("url", new Reference(baseRef, "../beans/" + key).getTargetRef());
            return info;
        }
        info.put("class", object.getClass().getName());
        LinkedList<Map<String, Object>> properties = new LinkedList<Map<String, Object>>();
        BeanWrapperImpl bwrap = new BeanWrapperImpl(object);
        for (PropertyDescriptor pd : this.getPropertyDescriptors(bwrap)) {
            if (pd.getReadMethod() == null || pd.isHidden()) continue;
            String propName = pd.getName();
            if (beanPath != null) {
                beanPathPrefix = beanPath + ".";
            }
            Map<String, Object> propValue = this.makePresentableMapFor(propName, bwrap.getPropertyValue(propName), alreadyWritten, beanPathPrefix);
            properties.add(propValue);
        }
        if (properties.size() > 0) {
            info.put("properties", properties);
        }
        LinkedList<Map<String, Object>> propValues = new LinkedList<Map<String, Object>>();
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            for (i = 0; i < len; ++i) {
                if (beanPath != null) {
                    beanPathPrefix = beanPath + "[";
                }
                propValues.add(this.makePresentableMapFor(i + "", Array.get(object, i), alreadyWritten, beanPathPrefix));
            }
        }
        if (object instanceof List) {
            List list = (List)object;
            for (i = 0; i < list.size(); ++i) {
                if (beanPath != null) {
                    beanPathPrefix = beanPath + "[";
                }
                try {
                    propValues.add(this.makePresentableMapFor(i + "", list.get(i), alreadyWritten, beanPathPrefix));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warning(list + ".get(" + i + ") -" + e);
                }
            }
        } else if (object instanceof Iterable) {
            for (Object next : (Iterable)object) {
                propValues.add(this.makePresentableMapFor("#", next, alreadyWritten, beanPathPrefix));
            }
        }
        if (object instanceof Map) {
            Iterator iterator = ((Map)object).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next;
                Map.Entry entry = next = iterator.next();
                if (beanPath != null) {
                    beanPathPrefix = beanPath + "[";
                }
                propValues.add(this.makePresentableMapFor(entry.getKey().toString(), entry.getValue(), alreadyWritten, beanPathPrefix));
            }
        }
        if (propValues.size() > 0) {
            info.put("propValue", propValues);
        }
        return info;
    }

    protected PropertyDescriptor[] getPropertyDescriptors(BeanWrapperImpl bwrap) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor pd : descriptors = bwrap.getPropertyDescriptors()) {
            if (DescriptorUpdater.class.isAssignableFrom(bwrap.getWrappedClass())) {
                ((DescriptorUpdater)bwrap.getWrappedInstance()).updateDescriptor(pd);
                continue;
            }
            this.defaultUpdateDescriptor(pd);
        }
        return descriptors;
    }

    private IdentityHashMap<Object, String> getBeanToNameMap() {
        if (this.beanToNameMap == null) {
            this.beanToNameMap = new IdentityHashMap();
            Iterator iterator = this.cj.getJobContext().getBeansOfType(Object.class).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryObj;
                Map.Entry entry = entryObj = iterator.next();
                this.beanToNameMap.put(entry.getValue(), (String)entry.getKey());
            }
        }
        return this.beanToNameMap;
    }

    protected void defaultUpdateDescriptor(PropertyDescriptor pd) {
        try {
            pd.setWriteMethod(null);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (HIDDEN_PROPS.contains(pd.getName())) {
            pd.setHidden(true);
        }
    }
}

