/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.archive.crawler.framework.Engine;
import org.archive.crawler.restlet.BeanBrowseResource;
import org.archive.crawler.restlet.EngineResource;
import org.archive.crawler.restlet.EnhDirectory;
import org.archive.crawler.restlet.JobResource;
import org.archive.crawler.restlet.ReportGenResource;
import org.archive.crawler.restlet.ScriptResource;
import org.archive.util.TextUtils;
import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Directory;
import org.restlet.routing.Redirector;
import org.restlet.routing.Router;
import org.restlet.service.StatusService;

public class EngineApplication
extends Application {
    protected Engine engine;
    private final Configuration templateConfiguration;

    public EngineApplication(Engine engine) {
        this.engine = engine;
        this.getMetadataService().addExtension("log", (Metadata)MediaType.TEXT_PLAIN);
        this.getMetadataService().addExtension("cxml", (Metadata)MediaType.APPLICATION_XML);
        this.setStatusService(new EngineStatusService());
        this.templateConfiguration = new Configuration();
        this.templateConfiguration.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "");
        this.templateConfiguration.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/", (Restlet)new Redirector(null, "/engine", 4));
        router.attach("/engine", EngineResource.class).setMatchingMode(2);
        router.attach("/engine/", EngineResource.class).setMatchingMode(2);
        Directory alljobsdir = new Directory(this.getContext(), this.engine.getJobsDir().toURI().toString());
        alljobsdir.setListingAllowed(true);
        router.attach("/engine/jobsdir", (Restlet)alljobsdir);
        EnhDirectory anypath = new EnhDirectory(this.getContext(), this.engine.getJobsDir().toURI().toString()){

            @Override
            protected Reference determineRootRef(Request request) {
                String ref = "file:/";
                return new Reference(ref);
            }
        };
        anypath.setListingAllowed(true);
        anypath.setModifiable(true);
        anypath.setEditFilter(JobResource.EDIT_FILTER);
        router.attach("/engine/anypath/", (Restlet)anypath);
        EnhDirectory jobdir = new EnhDirectory(this.getContext(), this.engine.getJobsDir().toURI().toString()){

            @Override
            protected Reference determineRootRef(Request request) {
                try {
                    return new Reference(EngineApplication.this.getEngine().getJob(TextUtils.urlUnescape((String)((String)request.getAttributes().get("job")))).getJobDir().getCanonicalFile().toURI().toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        jobdir.setListingAllowed(true);
        jobdir.setModifiable(true);
        jobdir.setEditFilter(JobResource.EDIT_FILTER);
        router.attach("/engine/job/{job}/jobdir", (Restlet)jobdir);
        router.attach("/engine/job/{job}", JobResource.class);
        router.attach("/engine/job/{job}/report/{reportClass}", ReportGenResource.class);
        router.attach("/engine/job/{job}/beans", BeanBrowseResource.class);
        router.attach("/engine/job/{job}/beans/{beanPath}", BeanBrowseResource.class);
        router.attach("/engine/job/{job}/script", ScriptResource.class);
        String resource = "clap://class/org/archive/crawler/restlet";
        Directory staticDir = new Directory(this.getContext(), resource);
        router.attach("/engine/static/", (Restlet)staticDir);
        return router;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Configuration getTemplateConfiguration() {
        return this.templateConfiguration;
    }

    protected class EngineStatusService
    extends StatusService {
        protected EngineStatusService() {
        }

        public Representation getRepresentation(Status status, Request request, Response response) {
            StringWriter st = new StringWriter();
            PrintWriter pw = new PrintWriter(st);
            if (status.getCode() == 404) {
                pw.append("<h1>Page not found</h1>\n");
                pw.append("The page you are looking for does not exist.  You may be able to recover by going <a href='javascript:history.back();void(0);'>back</a>.\n");
            } else {
                pw.append("<h1>An error occurred</h1>\n");
                pw.append("You may be able to recover and try something else by going <a href='javascript:history.back();void(0);'>back</a>.\n");
                if (status.getThrowable() != null) {
                    pw.append("<h2>Cause: " + status.getThrowable().toString() + "</h2>\n");
                    pw.append("<pre>");
                    status.getThrowable().printStackTrace(pw);
                    pw.append("</pre>");
                }
            }
            pw.flush();
            return new StringRepresentation((CharSequence)st.toString(), MediaType.TEXT_HTML);
        }
    }
}

