/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.restlet.JobRelatedResource;
import org.archive.crawler.restlet.XmlMarshaller;
import org.archive.crawler.restlet.models.BeansModel;
import org.archive.crawler.restlet.models.ViewModel;
import org.archive.spring.PathSharingContext;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;

public class BeanBrowseResource
extends JobRelatedResource {
    protected PathSharingContext appCtx;
    protected String beanPath;

    @Override
    public void init(Context ctx, Request req, Response res) throws ResourceException {
        super.init(ctx, req, res);
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        this.getVariants().add(new Variant(MediaType.APPLICATION_XML));
        this.appCtx = this.cj.getJobContext();
        this.beanPath = (String)req.getAttributes().get("beanPath");
        if (this.beanPath != null) {
            try {
                this.beanPath = URLDecoder.decode(this.beanPath, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            this.beanPath = "";
        }
    }

    protected Representation post(Representation entity, Variant variant) throws ResourceException {
        if (this.appCtx == null) {
            throw new ResourceException(404);
        }
        Form form = new Form(entity);
        this.beanPath = form.getFirstValue("beanPath");
        String newVal = form.getFirstValue("newVal");
        if (newVal != null) {
            int i = this.beanPath.indexOf(".");
            String beanName = i < 0 ? this.beanPath : this.beanPath.substring(0, i);
            Object namedBean = this.appCtx.getBean(beanName);
            BeanWrapperImpl bwrap = new BeanWrapperImpl(namedBean);
            String propPath = this.beanPath.substring(i + 1);
            Object coercedVal = bwrap.convertIfNecessary((Object)newVal, bwrap.getPropertyValue(propPath).getClass());
            bwrap.setPropertyValue(propPath, coercedVal);
        }
        Reference ref = this.getRequest().getResourceRef();
        ref.setPath(this.getBeansRefPath());
        ref.addSegment(this.beanPath);
        this.getResponse().redirectSeeOther(ref);
        return new EmptyRepresentation();
    }

    public String getBeansRefPath() {
        Reference ref = this.getRequest().getResourceRef();
        String path = ref.getPath();
        int i = path.indexOf("/beans/");
        if (i > 0) {
            return path.substring(0, i + "/beans/".length());
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public Representation get(Variant variant) throws ResourceException {
        if (this.appCtx == null) {
            throw new ResourceException(404);
        }
        if (variant.getMediaType() == MediaType.APPLICATION_XML) {
            return new WriterRepresentation(MediaType.APPLICATION_XML){

                public void write(Writer writer) throws IOException {
                    XmlMarshaller.marshalDocument(writer, "beans", BeanBrowseResource.this.makeDataModel());
                }
            };
        }
        ViewModel viewModel = new ViewModel();
        viewModel.put("model", this.makeDataModel());
        return this.render("Beans.ftl", viewModel);
    }

    protected BeansModel makeDataModel() {
        Map<String, Object> bean = null;
        String problem = null;
        boolean editable = false;
        Object target = null;
        if (StringUtils.isNotBlank((String)this.beanPath)) {
            try {
                int firstDot = this.beanPath.indexOf(".");
                String beanName = firstDot < 0 ? this.beanPath : this.beanPath.substring(0, firstDot);
                Object namedBean = this.appCtx.getBean(beanName);
                if (firstDot < 0) {
                    target = namedBean;
                    bean = this.makePresentableMapFor(null, target, this.beanPath);
                } else {
                    BeanWrapperImpl bwrap = new BeanWrapperImpl(namedBean);
                    String propPath = this.beanPath.substring(firstDot + 1);
                    target = bwrap.getPropertyValue(propPath);
                    Class type = bwrap.getPropertyType(propPath);
                    if (bwrap.isWritableProperty(propPath) && (bwrap.getDefaultEditor(type) != null || type == String.class) && !Collection.class.isAssignableFrom(type)) {
                        editable = true;
                        bean = this.makePresentableMapFor(null, target);
                    } else {
                        bean = this.makePresentableMapFor(null, target, this.beanPath);
                    }
                }
            }
            catch (BeansException e) {
                problem = e.toString();
            }
        }
        LinkedList<Object> nestedNames = new LinkedList<Object>();
        HashSet<Object> alreadyWritten = new HashSet<Object>();
        this.addPresentableNestedNames(nestedNames, this.appCtx.getBean("crawlController"), alreadyWritten);
        for (String name : this.appCtx.getBeanDefinitionNames()) {
            this.addPresentableNestedNames(nestedNames, this.appCtx.getBean(name), alreadyWritten);
        }
        return new BeansModel(this.cj.getShortName(), new Reference(this.getRequest().getResourceRef().getBaseRef(), "..").getTargetRef().toString(), this.beanPath, bean, editable, problem, target, nestedNames);
    }
}

