/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.archive.crawler.framework.Engine;
import org.archive.crawler.restlet.EngineApplication;
import org.archive.crawler.restlet.Flash;
import org.archive.crawler.restlet.models.ViewModel;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ServerResource;

public abstract class BaseResource
extends ServerResource {
    public EngineApplication getApplication() {
        return (EngineApplication)super.getApplication();
    }

    protected Engine getEngine() {
        return this.getApplication().getEngine();
    }

    protected String getStaticRef(String resource) {
        String rootRef = this.getRequest().getRootRef().toString();
        return rootRef + "/engine/static/" + resource;
    }

    protected Representation render(String templateName, ViewModel viewModel) {
        return this.render(templateName, viewModel, null);
    }

    protected Representation render(String templateName, final ViewModel viewModel, final ObjectWrapper objectWrapper) {
        Template template;
        String baseRef = this.getRequest().getResourceRef().getBaseRef().toString();
        if (!baseRef.endsWith("/")) {
            baseRef = baseRef + "/";
        }
        viewModel.put("baseRef", baseRef);
        viewModel.setFlashes(Flash.getFlashes(this.getRequest()));
        try {
            template = this.getApplication().getTemplateConfiguration().getTemplate(templateName);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading template " + templateName, e);
        }
        return new WriterRepresentation(MediaType.TEXT_HTML){

            public void write(Writer writer) throws IOException {
                try {
                    template.process((Object)viewModel, writer, objectWrapper);
                }
                catch (TemplateException e) {
                    throw new RuntimeException(e);
                }
                writer.flush();
            }
        };
    }
}

