/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.httpclient.URIException;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.crawler.io.NonFatalErrorFormatter;
import org.archive.crawler.io.RuntimeErrorFormatter;
import org.archive.crawler.io.StatisticsLogFormatter;
import org.archive.crawler.io.UriErrorFormatter;
import org.archive.crawler.io.UriProcessingFormatter;
import org.archive.crawler.reporting.AlertHandler;
import org.archive.crawler.reporting.AlertThreadGroup;
import org.archive.crawler.util.Logs;
import org.archive.io.GenerationFileHandler;
import org.archive.modules.SimpleFileLoggerProvider;
import org.archive.modules.extractor.UriErrorLoggerModule;
import org.archive.net.UURI;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class CrawlerLoggerModule
implements UriErrorLoggerModule,
Lifecycle,
InitializingBean,
Checkpointable,
SimpleFileLoggerProvider,
DisposableBean {
    private static final long serialVersionUID = 1L;
    protected ConfigPath path = new ConfigPath("logs subdirectory", "${launchId}/logs");
    protected boolean logExtraInfo = false;
    public static final char MANIFEST_CONFIG_FILE = 'C';
    public static final char MANIFEST_REPORT_FILE = 'R';
    public static final char MANIFEST_LOG_FILE = 'L';
    private static final String LOGNAME_CRAWL = "crawl";
    private static final String LOGNAME_ALERTS = "alerts";
    private static final String LOGNAME_PROGRESS_STATISTICS = "progress-statistics";
    private static final String LOGNAME_URI_ERRORS = "uri-errors";
    private static final String LOGNAME_RUNTIME_ERRORS = "runtime-errors";
    private static final String LOGNAME_NONFATAL_ERRORS = "nonfatal-errors";
    protected ConfigPath crawlLogPath = new ConfigPath(Logs.CRAWL.getFilename(), Logs.CRAWL.getFilename());
    protected ConfigPath alertsLogPath = new ConfigPath(Logs.ALERTS.getFilename(), Logs.ALERTS.getFilename());
    protected ConfigPath progressLogPath = new ConfigPath(Logs.PROGRESS_STATISTICS.getFilename(), Logs.PROGRESS_STATISTICS.getFilename());
    protected ConfigPath uriErrorsLogPath = new ConfigPath(Logs.URI_ERRORS.getFilename(), Logs.URI_ERRORS.getFilename());
    protected ConfigPath runtimeErrorsLogPath = new ConfigPath(Logs.RUNTIME_ERRORS.getFilename(), Logs.RUNTIME_ERRORS.getFilename());
    protected ConfigPath nonfatalErrorsLogPath = new ConfigPath(Logs.NONFATAL_ERRORS.getFilename(), Logs.NONFATAL_ERRORS.getFilename());
    private transient Logger uriProcessing;
    private transient Logger runtimeErrors;
    private transient Logger nonfatalErrors;
    private transient Logger uriErrors;
    private transient Logger progressStats;
    private transient Map<Logger, FileHandler> fileHandlers;
    private StringBuffer manifest = new StringBuffer();
    private transient AlertThreadGroup atg;
    protected boolean isRunning = false;
    protected Checkpoint recoveryCheckpoint;

    public ConfigPath getPath() {
        return this.path;
    }

    public void setPath(ConfigPath cp) {
        this.path.merge(cp);
    }

    public boolean getLogExtraInfo() {
        return this.logExtraInfo;
    }

    public void setLogExtraInfo(boolean logExtraInfo) {
        this.logExtraInfo = logExtraInfo;
    }

    public ConfigPath getCrawlLogPath() {
        return this.crawlLogPath;
    }

    public void setCrawlLogPath(ConfigPath cp) {
        this.crawlLogPath.merge(cp);
    }

    public ConfigPath getAlertsLogPath() {
        return this.alertsLogPath;
    }

    public void setAlertsLogPath(ConfigPath cp) {
        this.alertsLogPath.merge(cp);
    }

    public ConfigPath getProgressLogPath() {
        return this.progressLogPath;
    }

    public void setProgressLogPath(ConfigPath cp) {
        this.progressLogPath.merge(cp);
    }

    public ConfigPath getUriErrorsLogPath() {
        return this.uriErrorsLogPath;
    }

    public void setUriErrorsLogPath(ConfigPath cp) {
        this.uriErrorsLogPath.merge(cp);
    }

    public ConfigPath getRuntimeErrorsLogPath() {
        return this.runtimeErrorsLogPath;
    }

    public void setRuntimeErrorsLogPath(ConfigPath cp) {
        this.runtimeErrorsLogPath.merge(cp);
    }

    public ConfigPath getNonfatalErrorsLogPath() {
        return this.nonfatalErrorsLogPath;
    }

    public void setNonfatalErrorsLogPath(ConfigPath cp) {
        this.nonfatalErrorsLogPath.merge(cp);
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.atg = AlertThreadGroup.current();
        try {
            FileUtils.ensureWriteableDirectory((File)this.getPath().getFile());
            this.setupLogs();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void destroy() {
        this.closeLogFiles();
    }

    protected void setupLogs() throws IOException {
        String logsPath = this.getPath().getFile().getAbsolutePath() + File.separatorChar;
        this.uriProcessing = Logger.getLogger("crawl." + logsPath);
        this.runtimeErrors = Logger.getLogger("runtime-errors." + logsPath);
        this.nonfatalErrors = Logger.getLogger("nonfatal-errors." + logsPath);
        this.uriErrors = Logger.getLogger("uri-errors." + logsPath);
        this.progressStats = Logger.getLogger("progress-statistics." + logsPath);
        this.fileHandlers = new HashMap<Logger, FileHandler>();
        this.setupLogFile(this.uriProcessing, this.getCrawlLogPath().getFile().getAbsolutePath(), new UriProcessingFormatter(this.getLogExtraInfo()), true);
        this.setupLogFile(this.runtimeErrors, this.getRuntimeErrorsLogPath().getFile().getAbsolutePath(), new RuntimeErrorFormatter(this.getLogExtraInfo()), true);
        this.setupLogFile(this.nonfatalErrors, this.getNonfatalErrorsLogPath().getFile().getAbsolutePath(), new NonFatalErrorFormatter(this.getLogExtraInfo()), true);
        this.setupLogFile(this.uriErrors, this.getUriErrorsLogPath().getFile().getAbsolutePath(), new UriErrorFormatter(), true);
        this.setupLogFile(this.progressStats, this.getProgressLogPath().getFile().getAbsolutePath(), new StatisticsLogFormatter(), true);
        this.setupAlertLog(logsPath);
    }

    private void setupLogFile(Logger logger, String filename, Formatter f, boolean shouldManifest) throws IOException, SecurityException {
        logger.setLevel(Level.INFO);
        GenerationFileHandler fh = GenerationFileHandler.makeNew((String)filename, (boolean)false, (boolean)shouldManifest);
        fh.setFormatter(f);
        logger.addHandler((Handler)fh);
        this.addToManifest(filename, 'L', shouldManifest);
        logger.setUseParentHandlers(false);
        this.fileHandlers.put(logger, (FileHandler)fh);
    }

    public Logger setupSimpleLog(String logName) {
        Formatter f = new Formatter(){

            @Override
            public String format(LogRecord record) {
                return ArchiveUtils.getLog17Date((long)record.getMillis()) + " " + record.getMessage() + '\n';
            }
        };
        ConfigPath logPath = new ConfigPath(logName + ".log", logName + ".log");
        logPath.setBase(this.getPath());
        Logger logger = Logger.getLogger(logPath.getFile().getAbsolutePath());
        try {
            this.setupLogFile(logger, logPath.getFile().getAbsolutePath(), f, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return logger;
    }

    private void setupAlertLog(String logsPath) throws IOException {
        Logger logger = Logger.getLogger("alerts." + logsPath);
        String filename = this.getAlertsLogPath().getFile().getAbsolutePath();
        GenerationFileHandler fh = GenerationFileHandler.makeNew((String)filename, (boolean)false, (boolean)true);
        fh.setFormatter((Formatter)new SimpleFormatter());
        AlertThreadGroup.current().addLogger(logger);
        AlertHandler.ensureStaticInitialization();
        logger.addHandler((Handler)fh);
        this.addToManifest(filename, 'L', true);
        logger.setUseParentHandlers(false);
        this.fileHandlers.put(logger, (FileHandler)fh);
    }

    public void rotateLogFiles() throws IOException {
        this.rotateLogFiles("." + ArchiveUtils.get14DigitDate());
    }

    protected void rotateLogFiles(String generationSuffix) throws IOException {
        this.rotateLogFiles(generationSuffix, false);
    }

    protected void rotateLogFiles(String generationSuffix, boolean mergeOld) throws IOException {
        for (Logger l : this.fileHandlers.keySet()) {
            GenerationFileHandler gfh = (GenerationFileHandler)this.fileHandlers.get(l);
            GenerationFileHandler newGfh = gfh.rotate(generationSuffix, "", mergeOld);
            if (gfh.shouldManifest()) {
                this.addToManifest((String)newGfh.getFilenameSeries().get(1), 'L', newGfh.shouldManifest());
            }
            l.removeHandler((Handler)gfh);
            l.addHandler((Handler)newGfh);
            this.fileHandlers.put(l, (FileHandler)newGfh);
        }
    }

    public void closeLogFiles() {
        if (this.fileHandlers != null) {
            for (Logger l : this.fileHandlers.keySet()) {
                GenerationFileHandler gfh = (GenerationFileHandler)this.fileHandlers.get(l);
                gfh.close();
                l.removeHandler((Handler)gfh);
            }
        }
    }

    public void addToManifest(String file, char type, boolean bundle) {
        this.manifest.append(type + (bundle ? "+" : "-") + " " + file + "\n");
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        this.rotateLogFiles("." + checkpointInProgress.getName(), checkpointInProgress.getForgetAllButLatest());
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    @Autowired(required=false)
    public void setRecoveryCheckpoint(Checkpoint checkpoint) {
        this.recoveryCheckpoint = checkpoint;
    }

    public Logger getNonfatalErrors() {
        return this.nonfatalErrors;
    }

    public Logger getProgressStats() {
        return this.progressStats;
    }

    public Logger getRuntimeErrors() {
        return this.runtimeErrors;
    }

    public Logger getUriErrors() {
        return this.uriErrors;
    }

    public Logger getUriProcessing() {
        return this.uriProcessing;
    }

    public int getAlertCount() {
        if (this.atg != null) {
            return this.atg.getAlertCount();
        }
        return -1;
    }

    public void resetAlertCount() {
        if (this.atg != null) {
            this.atg.resetAlertCount();
        }
    }

    public void logUriError(URIException e, UURI u, CharSequence l) {
        Object[] array = new Object[]{u, l};
        this.uriErrors.log(Level.INFO, e.getMessage(), array);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getPath().getFile().mkdirs();
        this.atg = AlertThreadGroup.current();
        this.setupLogs();
    }

    public void afterPropertiesSet() throws Exception {
        ConfigPath[] paths;
        for (ConfigPath cp : paths = new ConfigPath[]{this.crawlLogPath, this.alertsLogPath, this.progressLogPath, this.uriErrorsLogPath, this.runtimeErrorsLogPath, this.nonfatalErrorsLogPath}) {
            if (cp.getBase() != null) continue;
            cp.setBase(this.getPath());
        }
    }
}

