/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.PrintWriter;
import org.archive.crawler.reporting.CrawlStatSnapshot;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.StatisticsTracker;
import org.archive.util.ArchiveUtils;
import org.springframework.util.StringUtils;

public class CrawlSummaryReport
extends Report {
    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        CrawlStatSnapshot snapshot = stats.getLastSnapshot();
        writer.println("crawl name: " + stats.getCrawlController().getMetadata().getJobName());
        String crawlStatus = stats.getCrawlController().getCrawlExitStatus().desc;
        if (stats.getCrawlController().isRunning()) {
            crawlStatus = StringUtils.capitalize((String)stats.getCrawlController().getState().toString().toLowerCase()) + " - Active";
        }
        writer.println("crawl status: " + crawlStatus);
        writer.println("duration: " + ArchiveUtils.formatMillisecondsToConventional((long)stats.getCrawlElapsedTime()));
        writer.println();
        stats.tallySeeds();
        writer.println("seeds crawled: " + stats.seedsCrawled);
        writer.println("seeds uncrawled: " + (stats.seedsTotal - stats.seedsCrawled));
        writer.println();
        writer.println("hosts visited: " + (stats.serverCache.hostKeys().size() - 1));
        writer.println();
        writer.println("URIs processed: " + snapshot.finishedUriCount);
        writer.println("URI successes: " + snapshot.downloadedUriCount);
        writer.println("URI failures: " + snapshot.downloadFailures);
        writer.println("URI disregards: " + snapshot.downloadDisregards);
        writer.println();
        writer.println("novel URIs: " + stats.crawledBytes.get((Object)"novelCount"));
        if (stats.crawledBytes.containsKey((Object)"dupByHashCount")) {
            writer.println("duplicate-by-hash URIs: " + stats.crawledBytes.get((Object)"dupByHashCount"));
        }
        if (stats.crawledBytes.containsKey((Object)"notModifiedCount")) {
            writer.println("not-modified URIs: " + stats.crawledBytes.get((Object)"notModifiedCount"));
        }
        writer.println();
        writer.println("total crawled bytes: " + snapshot.bytesProcessed + " (" + ArchiveUtils.formatBytesForDisplay((long)snapshot.bytesProcessed) + ") ");
        writer.println("novel crawled bytes: " + stats.crawledBytes.get((Object)"novel") + " (" + ArchiveUtils.formatBytesForDisplay((long)stats.crawledBytes.get((Object)"novel")) + ")");
        if (stats.crawledBytes.containsKey((Object)"dupByHash")) {
            writer.println("duplicate-by-hash crawled bytes: " + stats.crawledBytes.get((Object)"dupByHash") + " (" + ArchiveUtils.formatBytesForDisplay((long)stats.crawledBytes.get((Object)"dupByHash")) + ") ");
        }
        if (stats.crawledBytes.containsKey((Object)"notModified")) {
            writer.println("not-modified crawled bytes: " + stats.crawledBytes.get((Object)"notModified") + " (" + ArchiveUtils.formatBytesForDisplay((long)stats.crawledBytes.get((Object)"notModified")) + ") ");
        }
        writer.println();
        writer.println("URIs/sec: " + ArchiveUtils.doubleToString((double)snapshot.docsPerSecond, (int)2));
        writer.println("KB/sec: " + snapshot.totalKiBPerSec);
    }

    @Override
    public String getFilename() {
        return "crawl-report.txt";
    }
}

