/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.processor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.deciderules.AcceptDecideRule;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;
import org.archive.util.fingerprint.ArrayLongFPCache;
import org.springframework.context.Lifecycle;
import st.ata.util.FPGenerator;

public abstract class CrawlMapper
extends Processor
implements Lifecycle {
    protected boolean checkUri = true;
    protected boolean checkOutlinks = true;
    protected DecideRule outlinkRule = new AcceptDecideRule();
    protected String localName = ".";
    protected ConfigPath diversionDir = new ConfigPath("diverted URIs subdirectory", "diversions");
    protected int rotationDigits = 10;
    protected HashMap<String, PrintWriter> diversionLogs = new HashMap();
    protected String logGeneration = "";
    protected ArrayLongFPCache cache;

    public boolean getCheckUri() {
        return this.checkUri;
    }

    public void setCheckUri(boolean check) {
        this.checkUri = check;
    }

    public boolean getCheckOutlinks() {
        return this.checkOutlinks;
    }

    public void setCheckOutlinks(boolean check) {
        this.checkOutlinks = check;
    }

    public DecideRule getOutlinkRule() {
        return this.outlinkRule;
    }

    public void setOutlinkRule(DecideRule rule) {
        this.outlinkRule = rule;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String name) {
        this.localName = name;
    }

    public ConfigPath getDiversionDir() {
        return this.diversionDir;
    }

    public void setDiversionDir(ConfigPath path) {
        this.diversionDir = path;
    }

    public int getRotationDigits() {
        return this.rotationDigits;
    }

    public void setRotationDigits(int digits) {
        this.rotationDigits = digits;
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return true;
    }

    protected void innerProcess(CrawlURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(CrawlURI puri) {
        String target;
        CrawlURI curi = puri;
        String nowGeneration = ArchiveUtils.get14DigitDate().substring(0, this.getRotationDigits());
        if (!nowGeneration.equals(this.logGeneration)) {
            this.updateGeneration(nowGeneration);
        }
        if (curi.getFetchStatus() <= 0 && this.getCheckUri() && !this.localName.equals(target = this.map(curi))) {
            curi.setFetchStatus(-5002);
            curi.getAnnotations().add("to:" + target);
            this.divertLog(curi, target);
            return ProcessResult.FINISH;
        }
        if (this.getCheckOutlinks()) {
            Iterator iter = curi.getOutLinks().iterator();
            while (iter.hasNext()) {
                String target2;
                CrawlURI cauri = (CrawlURI)iter.next();
                if (!this.decideToMapOutlink(cauri) || this.localName.equals(target2 = this.map(cauri))) continue;
                iter.remove();
                this.divertLog(cauri, target2);
            }
        }
        return ProcessResult.PROCEED;
    }

    protected boolean decideToMapOutlink(CrawlURI cauri) {
        DecideRule rule = this.getOutlinkRule();
        boolean rejected = rule.decisionFor(cauri).equals((Object)DecideResult.REJECT);
        return !rejected;
    }

    protected synchronized void updateGeneration(String nowGeneration) {
        for (FilePrintWriter filePrintWriter : this.diversionLogs.values()) {
            filePrintWriter.close();
            filePrintWriter.getFile().renameTo(new File(filePrintWriter.getFile().getAbsolutePath().replaceFirst("\\.open$", ".divert")));
        }
        this.diversionLogs.clear();
        this.logGeneration = nowGeneration;
    }

    protected abstract String map(CrawlURI var1);

    protected synchronized void divertLog(CrawlURI cauri, String target) {
        if (this.recentlySeen(cauri)) {
            return;
        }
        PrintWriter diversionLog = this.getDiversionLog(target);
        diversionLog.print(cauri.getClassKey());
        diversionLog.print(" ");
        cauri.shortReportLineTo(diversionLog);
        diversionLog.println();
    }

    private boolean recentlySeen(CrawlURI cauri) {
        long fp = FPGenerator.std64.fp((CharSequence)cauri.toString());
        return !this.cache.add(fp);
    }

    protected PrintWriter getDiversionLog(String target) {
        FilePrintWriter writer = (FilePrintWriter)this.diversionLogs.get(target);
        if (writer == null) {
            File divertDir = this.getDiversionDir().getFile();
            divertDir.mkdirs();
            File divertLog = new File(divertDir, this.logGeneration + "-" + this.localName + "-to-" + target + ".open");
            try {
                writer = new FilePrintWriter(divertLog);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.diversionLogs.put(target, writer);
        }
        return writer;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.cache = new ArrayLongFPCache();
    }

    public boolean isRunning() {
        return this.cache != null;
    }

    public void stop() {
        this.cache = null;
    }

    private class FilePrintWriter
    extends PrintWriter {
        File file;

        public FilePrintWriter(File file) throws FileNotFoundException {
            super(new BufferedOutputStream(new FileOutputStream(file)));
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

