/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.CrawlStatus;
import org.archive.crawler.reporting.StatisticsTracker;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.springframework.beans.factory.annotation.Autowired;

public class RuntimeLimitEnforcer
extends Processor {
    private static final long serialVersionUID = 3L;
    protected static Logger logger = Logger.getLogger(RuntimeLimitEnforcer.class.getName());
    protected long runtimeSeconds = 86400L;
    protected Operation expirationOperation = Operation.PAUSE;
    protected CrawlController controller;
    protected StatisticsTracker statisticsTracker;

    public long getRuntimeSeconds() {
        return this.runtimeSeconds;
    }

    public void setRuntimeSeconds(long secs) {
        this.runtimeSeconds = secs;
    }

    public Operation getExpirationOperation() {
        return this.expirationOperation;
    }

    public void setExpirationOperation(Operation op) {
        this.expirationOperation = op;
    }

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public StatisticsTracker getStatisticsTracker() {
        return this.statisticsTracker;
    }

    @Autowired
    public void setStatisticsTracker(StatisticsTracker statisticsTracker) {
        this.statisticsTracker = statisticsTracker;
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(CrawlURI curi) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(CrawlURI curi) throws InterruptedException {
        CrawlController controller = this.getCrawlController();
        StatisticsTracker stats = this.getStatisticsTracker();
        long allowedRuntimeMs = this.getRuntimeSeconds() * 1000L;
        long currentRuntimeMs = stats.getCrawlElapsedTime();
        if (currentRuntimeMs > allowedRuntimeMs) {
            Operation op = this.getExpirationOperation();
            if (op != null) {
                if (op.equals((Object)Operation.PAUSE)) {
                    controller.requestCrawlPause();
                } else if (op.equals((Object)Operation.TERMINATE)) {
                    controller.requestCrawlStop(CrawlStatus.FINISHED_TIME_LIMIT);
                } else if (op.equals((Object)Operation.BLOCK_URIS)) {
                    curi.setFetchStatus(-5004);
                    curi.getAnnotations().add("Runtime exceeded " + allowedRuntimeMs + "ms");
                    return ProcessResult.FINISH;
                }
            } else {
                logger.log(Level.SEVERE, "Null value for end-operation  when processing " + curi.toString());
            }
        }
        return ProcessResult.PROCEED;
    }

    public static enum Operation {
        PAUSE,
        TERMINATE,
        BLOCK_URIS;

    }
}

