/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.framework.Frontier;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.fetcher.FetchStats;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.springframework.beans.factory.annotation.Autowired;

public class QuotaEnforcer
extends Processor {
    private static final long serialVersionUID = 3L;
    private static final Logger LOGGER = Logger.getLogger(QuotaEnforcer.class.getName());
    protected static final int SERVER = 0;
    protected static final int HOST = 1;
    protected static final int GROUP = 2;
    protected static final int SUCCESSES = 0;
    protected static final int SUCCESS_KB = 1;
    protected static final int RESPONSES = 2;
    protected static final int RESPONSE_KB = 3;
    protected static final int NOVEL_KB = 4;
    protected static final int NOVEL_URLS = 5;
    private static final String SERVER_MAX_FETCH_SUCCESSES = "serverMaxFetchSuccesses";
    private static final String SERVER_MAX_SUCCESS_KB = "serverMaxSuccessKb";
    private static final String SERVER_MAX_FETCH_RESPONSES = "serverMaxFetchResponses";
    private static final String SERVER_MAX_ALL_KB = "serverMaxAllKb";
    private static final String SERVER_MAX_NOVEL_KB = "serverMaxNovelKb";
    private static final String SERVER_MAX_NOVEL_URLS = "serverMaxNovelUrls";
    private static final String HOST_MAX_FETCH_SUCCESSES = "hostMaxFetchSuccesses";
    private static final String HOST_MAX_SUCCESS_KB = "hostMaxSuccessKb";
    private static final String HOST_MAX_FETCH_RESPONSES = "hostMaxFetchResponses";
    private static final String HOST_MAX_ALL_KB = "hostMaxAllKb";
    private static final String HOST_MAX_NOVEL_KB = "hostMaxNovelKb";
    private static final String HOST_MAX_NOVEL_URLS = "hostMaxNovelUrls";
    private static final String GROUP_MAX_FETCH_SUCCESSES = "groupMaxFetchSuccesses";
    private static final String GROUP_MAX_SUCCESS_KB = "groupMaxSuccessKb";
    private static final String GROUP_MAX_FETCH_RESPONSES = "groupMaxFetchResponses";
    private static final String GROUP_MAX_ALL_KB = "groupMaxAllKb";
    private static final String GROUP_MAX_NOVEL_KB = "serverMaxNovelKb";
    private static final String GROUP_MAX_NOVEL_URLS = "serverMaxNovelUrls";
    protected static final String[][] keys = new String[][]{{"serverMaxFetchSuccesses", "serverMaxSuccessKb", "serverMaxFetchResponses", "serverMaxAllKb", "serverMaxNovelKb", "serverMaxNovelUrls"}, {"hostMaxFetchSuccesses", "hostMaxSuccessKb", "hostMaxFetchResponses", "hostMaxAllKb", "hostMaxNovelKb", "hostMaxNovelUrls"}, {"groupMaxFetchSuccesses", "groupMaxSuccessKb", "groupMaxFetchResponses", "groupMaxAllKb", "serverMaxNovelKb", "serverMaxNovelUrls"}};
    protected ServerCache serverCache;
    protected Frontier frontier;

    public QuotaEnforcer() {
        this.setServerMaxFetchSuccesses(-1L);
        this.setServerMaxSuccessKb(-1L);
        this.setServerMaxFetchResponses(-1L);
        this.setServerMaxAllKb(-1L);
        this.setServerMaxNovelKb(-1L);
        this.setServerMaxNovelUrls(-1L);
        this.setHostMaxFetchSuccesses(-1L);
        this.setHostMaxSuccessKb(-1L);
        this.setHostMaxFetchResponses(-1L);
        this.setHostMaxNovelKb(-1L);
        this.setHostMaxNovelUrls(-1L);
        this.setHostMaxAllKb(-1L);
        this.setGroupMaxFetchSuccesses(-1L);
        this.setGroupMaxSuccessKb(-1L);
        this.setGroupMaxFetchResponses(-1L);
        this.setGroupMaxAllKb(-1L);
        this.setGroupMaxNovelKb(-1L);
        this.setGroupMaxNovelUrls(-1L);
        this.setForceRetire(true);
    }

    public long getServerMaxFetchSuccesses() {
        return (Long)this.kp.get(SERVER_MAX_FETCH_SUCCESSES);
    }

    public void setServerMaxFetchSuccesses(long max) {
        this.kp.put((Object)SERVER_MAX_FETCH_SUCCESSES, (Object)max);
    }

    public long getServerMaxSuccessKb() {
        return (Long)this.kp.get(SERVER_MAX_SUCCESS_KB);
    }

    public void setServerMaxSuccessKb(long max) {
        this.kp.put((Object)SERVER_MAX_SUCCESS_KB, (Object)max);
    }

    public long getServerMaxFetchResponses() {
        return (Long)this.kp.get(SERVER_MAX_FETCH_RESPONSES);
    }

    public void setServerMaxFetchResponses(long max) {
        this.kp.put((Object)SERVER_MAX_FETCH_RESPONSES, (Object)max);
    }

    public long getServerMaxAllKb() {
        return (Long)this.kp.get(SERVER_MAX_ALL_KB);
    }

    public void setServerMaxAllKb(long max) {
        this.kp.put((Object)SERVER_MAX_ALL_KB, (Object)max);
    }

    public long getServerMaxNovelKb() {
        return (Long)this.kp.get("serverMaxNovelKb");
    }

    public void setServerMaxNovelKb(long max) {
        this.kp.put((Object)"serverMaxNovelKb", (Object)max);
    }

    public long getServerMaxNovelUrls() {
        return (Long)this.kp.get("serverMaxNovelUrls");
    }

    public void setServerMaxNovelUrls(long max) {
        this.kp.put((Object)"serverMaxNovelUrls", (Object)max);
    }

    public long getHostMaxFetchSuccesses() {
        return (Long)this.kp.get(HOST_MAX_FETCH_SUCCESSES);
    }

    public void setHostMaxFetchSuccesses(long max) {
        this.kp.put((Object)HOST_MAX_FETCH_SUCCESSES, (Object)max);
    }

    public long getHostMaxSuccessKb() {
        return (Long)this.kp.get(HOST_MAX_SUCCESS_KB);
    }

    public void setHostMaxSuccessKb(long max) {
        this.kp.put((Object)HOST_MAX_SUCCESS_KB, (Object)max);
    }

    public long getHostMaxFetchResponses() {
        return (Long)this.kp.get(HOST_MAX_FETCH_RESPONSES);
    }

    public void setHostMaxFetchResponses(long max) {
        this.kp.put((Object)HOST_MAX_FETCH_RESPONSES, (Object)max);
    }

    public long getHostMaxNovelKb() {
        return (Long)this.kp.get(HOST_MAX_NOVEL_KB);
    }

    public void setHostMaxNovelKb(long max) {
        this.kp.put((Object)HOST_MAX_NOVEL_KB, (Object)max);
    }

    public long getHostMaxNovelUrls() {
        return (Long)this.kp.get(HOST_MAX_NOVEL_URLS);
    }

    public void setHostMaxNovelUrls(long max) {
        this.kp.put((Object)HOST_MAX_NOVEL_URLS, (Object)max);
    }

    public long getHostMaxAllKb() {
        return (Long)this.kp.get(HOST_MAX_ALL_KB);
    }

    public void setHostMaxAllKb(long max) {
        this.kp.put((Object)HOST_MAX_ALL_KB, (Object)max);
    }

    public long getGroupMaxFetchSuccesses() {
        return (Long)this.kp.get(GROUP_MAX_FETCH_SUCCESSES);
    }

    public void setGroupMaxFetchSuccesses(long max) {
        this.kp.put((Object)GROUP_MAX_FETCH_SUCCESSES, (Object)max);
    }

    public long getGroupMaxSuccessKb() {
        return (Long)this.kp.get(GROUP_MAX_SUCCESS_KB);
    }

    public void setGroupMaxSuccessKb(long max) {
        this.kp.put((Object)GROUP_MAX_SUCCESS_KB, (Object)max);
    }

    public long getGroupMaxFetchResponses() {
        return (Long)this.kp.get(GROUP_MAX_FETCH_RESPONSES);
    }

    public void setGroupMaxFetchResponses(long max) {
        this.kp.put((Object)GROUP_MAX_FETCH_RESPONSES, (Object)max);
    }

    public long getGroupMaxAllKb() {
        return (Long)this.kp.get(GROUP_MAX_ALL_KB);
    }

    public void setGroupMaxAllKb(long max) {
        this.kp.put((Object)GROUP_MAX_ALL_KB, (Object)max);
    }

    public long getGroupMaxNovelKb() {
        return (Long)this.kp.get("serverMaxNovelKb");
    }

    public void setGroupMaxNovelKb(long max) {
        this.kp.put((Object)"serverMaxNovelKb", (Object)max);
    }

    public long getGroupMaxNovelUrls() {
        return (Long)this.kp.get("serverMaxNovelUrls");
    }

    public void setGroupMaxNovelUrls(long max) {
        this.kp.put((Object)"serverMaxNovelUrls", (Object)max);
    }

    public boolean getForceRetire() {
        return (Boolean)this.kp.get("forceRetire");
    }

    public void setForceRetire(boolean force) {
        this.kp.put((Object)"forceRetire", (Object)force);
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    @Autowired
    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(CrawlURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(CrawlURI puri) {
        CrawlURI curi = puri;
        CrawlServer server = this.serverCache.getServerFor(curi.getUURI());
        CrawlHost host = this.serverCache.getHostFor(curi.getUURI());
        FetchStats.HasFetchStats[] haveStats = new FetchStats.HasFetchStats[]{server, host, this.frontier.getGroup(curi)};
        for (int cat = 0; cat <= 2; ++cat) {
            if (!this.checkQuotas(curi, haveStats[cat], cat)) continue;
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    protected boolean checkQuotas(CrawlURI curi, FetchStats.HasFetchStats hasStats, int CAT) {
        if (hasStats == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(curi.toString() + " null stats category: " + CAT);
            }
            return false;
        }
        FetchStats substats = hasStats.getSubstats();
        long[] actuals = new long[]{substats.getFetchSuccesses(), substats.getSuccessBytes() / 1024L, substats.getFetchResponses(), substats.getTotalBytes() / 1024L, substats.getNovelBytes() / 1024L, substats.getNovelUrls()};
        for (int q = 0; q <= 5; ++q) {
            String key = keys[CAT][q];
            if (!this.applyQuota(curi, key, actuals[q])) continue;
            return true;
        }
        return false;
    }

    protected boolean applyQuota(CrawlURI curi, String key, long actual) {
        long quota = (Long)this.kp.get(key);
        if (quota >= 0L && actual >= quota) {
            curi.getAnnotations().add("Q:" + key);
            if (this.getForceRetire()) {
                curi.setForceRetire(true);
            } else {
                curi.setFetchStatus(-5003);
            }
            return true;
        }
        return false;
    }
}

