/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.reporting.CrawlerLoggerModule;
import org.archive.modules.CrawlMetadata;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.CredentialStore;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.RobotsPolicy;
import org.archive.modules.net.ServerCache;
import org.archive.net.UURI;
import org.springframework.beans.factory.annotation.Autowired;

public class PreconditionEnforcer
extends Processor {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(PreconditionEnforcer.class.getName());
    protected CrawlMetadata metadata;
    protected ServerCache serverCache;
    protected CrawlerLoggerModule loggerModule;

    public int getIpValidityDurationSeconds() {
        return (Integer)this.kp.get("ipValidityDurationSeconds");
    }

    public void setIpValidityDurationSeconds(int duration) {
        this.kp.put((Object)"ipValidityDurationSeconds", (Object)duration);
    }

    public int getRobotsValidityDurationSeconds() {
        return (Integer)this.kp.get("robotsValidityDurationSeconds");
    }

    public void setRobotsValidityDurationSeconds(int duration) {
        this.kp.put((Object)"robotsValidityDurationSeconds", (Object)duration);
    }

    public boolean getCalculateRobotsOnly() {
        return (Boolean)this.kp.get("calculateRobotsOnly");
    }

    public void setCalculateRobotsOnly(boolean calcOnly) {
        this.kp.put((Object)"calculateRobotsOnly", (Object)calcOnly);
    }

    public CrawlMetadata getMetadata() {
        return this.metadata;
    }

    @Autowired
    public void setMetadata(CrawlMetadata provider) {
        this.metadata = provider;
    }

    public CredentialStore getCredentialStore() {
        return (CredentialStore)this.kp.get("credentialStore");
    }

    @Autowired(required=false)
    public void setCredentialStore(CredentialStore credentials) {
        this.kp.put((Object)"credentialStore", (Object)credentials);
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public CrawlerLoggerModule getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(CrawlerLoggerModule loggerModule) {
        this.loggerModule = loggerModule;
    }

    public PreconditionEnforcer() {
        this.setIpValidityDurationSeconds(21600);
        this.setRobotsValidityDurationSeconds(86400);
        this.setCalculateRobotsOnly(false);
        this.setCredentialStore(new CredentialStore());
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(CrawlURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(CrawlURI puri) {
        CrawlURI curi = puri;
        if (this.considerDnsPreconditions(curi)) {
            return ProcessResult.FINISH;
        }
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (!scheme.equals("http") && !scheme.equals("https")) {
            logger.fine("PolitenessEnforcer doesn't understand uri's of type " + scheme + " (ignoring)");
            return ProcessResult.PROCEED;
        }
        if (this.considerRobotsPreconditions(curi)) {
            return ProcessResult.FINISH;
        }
        if (!curi.isPrerequisite() && this.credentialPrecondition(curi)) {
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    protected boolean considerRobotsPreconditions(CrawlURI curi) {
        UURI uuri = curi.getUURI();
        try {
            if (uuri != null && uuri.getPath() != null && curi.getUURI().getPath().equals("/robots.txt")) {
                curi.setPrerequisite(true);
                return false;
            }
        }
        catch (URIException e) {
            logger.severe("Failed get of path for " + curi);
        }
        CrawlServer cs = this.serverCache.getServerFor(curi.getUURI());
        if (cs.isRobotsExpired(this.getRobotsValidityDurationSeconds())) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No valid robots for " + cs + "; deferring " + curi);
            }
            try {
                String prereq = curi.getUURI().resolve("/robots.txt").toString();
                curi.markPrerequisite(prereq);
            }
            catch (URIException e1) {
                logger.severe("Failed resolve using " + curi);
                throw new RuntimeException(e1);
            }
            return true;
        }
        if (cs.isValidRobots()) {
            String ua = this.metadata.getUserAgent();
            RobotsPolicy robots = this.metadata.getRobotsPolicy();
            if (!robots.allows(ua, curi, cs.getRobotstxt())) {
                if (this.getCalculateRobotsOnly()) {
                    curi.getAnnotations().add("robotExcluded");
                    return false;
                }
                curi.setFetchStatus(-9998);
                curi.setError("robots.txt exclusion");
                logger.fine("robots.txt precluded " + curi);
                return true;
            }
            return false;
        }
        curi.setFetchStatus(-61);
        curi.setError("robots.txt prerequisite failed");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("robots.txt prerequisite failed " + curi);
        }
        return true;
    }

    protected boolean considerDnsPreconditions(CrawlURI curi) {
        if (curi.getUURI().getScheme().equals("dns")) {
            curi.setPrerequisite(true);
            return false;
        }
        if (curi.getUURI().getScheme().equals("whois")) {
            return false;
        }
        CrawlServer cs = this.serverCache.getServerFor(curi.getUURI());
        if (cs == null) {
            curi.setFetchStatus(-7);
            return true;
        }
        CrawlHost ch = this.serverCache.getHostFor(curi.getUURI());
        if (ch == null || ch.getIP() == null && !this.isIpExpired(curi)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("no dns for " + ch + " cancelling processing for CrawlURI " + curi.toString());
            }
            curi.setFetchStatus(-6);
            return true;
        }
        if (this.isIpExpired(curi) && !curi.getUURI().getScheme().equals("dns")) {
            logger.fine("Deferring processing of CrawlURI " + curi.toString() + " for dns lookup.");
            String preq = "dns:" + ch.getHostName();
            try {
                curi.markPrerequisite(preq);
            }
            catch (URIException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    public boolean isIpExpired(CrawlURI curi) {
        CrawlHost host = this.serverCache.getHostFor(curi.getUURI());
        if (!host.hasBeenLookedUp()) {
            return true;
        }
        if (host.getIpTTL() == -1L) {
            return false;
        }
        long duration = this.getIpValidityDurationSeconds();
        if (duration == 0L) {
            return false;
        }
        long ttl = host.getIpTTL();
        if (ttl > duration) {
            duration = ttl;
        }
        if (duration > 0L) {
            duration *= 1000L;
        }
        return duration + host.getIpFetched() < System.currentTimeMillis();
    }

    public boolean credentialPrecondition(CrawlURI curi) {
        boolean result = false;
        CredentialStore cs = this.getCredentialStore();
        if (cs == null) {
            logger.severe("No credential store for " + curi);
            return result;
        }
        for (Credential c : cs.getAll()) {
            if (c.isPrerequisite(curi)) {
                logger.fine("attaching credential and setting fetch type to POST for recognized form login url " + curi);
                c.attach(curi);
                curi.setFetchType(CrawlURI.FetchType.HTTP_POST);
                break;
            }
            if (!c.rootUriMatch(this.serverCache, curi) || !c.hasPrerequisite(curi) || this.authenticated(c, curi)) continue;
            String prereq = c.getPrerequisite(curi);
            if (prereq == null || prereq.length() <= 0) {
                CrawlServer server = this.serverCache.getServerFor(curi.getUURI());
                logger.severe(server.getName() + " has  credential(s) of type " + c + " but prereq is null.");
                continue;
            }
            try {
                curi.markPrerequisite(prereq);
            }
            catch (URIException e) {
                logger.severe("unable to set credentials prerequisite " + prereq);
                this.loggerModule.logUriError(e, curi.getUURI(), prereq);
                return false;
            }
            result = true;
            if (!logger.isLoggable(Level.FINE)) break;
            logger.fine("Queueing prereq " + prereq + " of type " + c + " for " + curi);
            break;
        }
        return result;
    }

    protected boolean authenticated(Credential credential, CrawlURI curi) {
        CrawlServer server = this.serverCache.getServerFor(curi.getUURI());
        if (!server.hasCredentials()) {
            return false;
        }
        Set credentials = server.getCredentials();
        for (Credential cred : credentials) {
            if (!cred.getKey().equals(credential.getKey()) || !cred.getClass().isInstance(credential)) continue;
            return true;
        }
        return false;
    }
}

