/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import org.apache.commons.lang.StringUtils;
import org.archive.crawler.framework.Scoper;
import org.archive.crawler.frontier.CostAssignmentPolicy;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.crawler.frontier.SurtAuthorityQueueAssignmentPolicy;
import org.archive.crawler.frontier.UnitCostAssignmentPolicy;
import org.archive.crawler.frontier.precedence.CostUriPrecedencePolicy;
import org.archive.crawler.frontier.precedence.UriPrecedencePolicy;
import org.archive.modules.CrawlURI;
import org.archive.modules.canonicalize.RulesCanonicalizationPolicy;
import org.archive.modules.canonicalize.UriCanonicalizationPolicy;
import org.archive.spring.KeyedProperties;
import org.archive.spring.OverlayContext;
import org.springframework.beans.factory.annotation.Autowired;

public class FrontierPreparer
extends Scoper {
    private static final long serialVersionUID = 1L;

    public FrontierPreparer() {
        this.setPreferenceDepthHops(-1);
        this.setPreferenceEmbedHops(1);
        this.setCanonicalizationPolicy((UriCanonicalizationPolicy)new RulesCanonicalizationPolicy());
        this.setQueueAssignmentPolicy(new SurtAuthorityQueueAssignmentPolicy());
        this.setUriPrecedencePolicy(new CostUriPrecedencePolicy());
        this.setCostAssignmentPolicy(new UnitCostAssignmentPolicy());
    }

    public int getPreferenceDepthHops() {
        return (Integer)this.kp.get("preferenceDepthHops");
    }

    public void setPreferenceDepthHops(int depth) {
        this.kp.put((Object)"preferenceDepthHops", (Object)depth);
    }

    public int getPreferenceEmbedHops() {
        return (Integer)this.kp.get("preferenceEmbedHops");
    }

    public void setPreferenceEmbedHops(int pref) {
        this.kp.put((Object)"preferenceEmbedHops", (Object)pref);
    }

    public UriCanonicalizationPolicy getCanonicalizationPolicy() {
        return (UriCanonicalizationPolicy)this.kp.get("uriCanonicalizationRules");
    }

    @Autowired(required=false)
    public void setCanonicalizationPolicy(UriCanonicalizationPolicy policy) {
        this.kp.put((Object)"uriCanonicalizationRules", (Object)policy);
    }

    public QueueAssignmentPolicy getQueueAssignmentPolicy() {
        return (QueueAssignmentPolicy)this.kp.get("queueAssignmentPolicy");
    }

    @Autowired(required=false)
    public void setQueueAssignmentPolicy(QueueAssignmentPolicy policy) {
        this.kp.put((Object)"queueAssignmentPolicy", (Object)policy);
    }

    public UriPrecedencePolicy getUriPrecedencePolicy() {
        return (UriPrecedencePolicy)this.kp.get("uriPrecedencePolicy");
    }

    @Autowired(required=false)
    public void setUriPrecedencePolicy(UriPrecedencePolicy policy) {
        this.kp.put((Object)"uriPrecedencePolicy", (Object)policy);
    }

    public CostAssignmentPolicy getCostAssignmentPolicy() {
        return (CostAssignmentPolicy)this.kp.get("costAssignmentPolicy");
    }

    @Autowired(required=false)
    public void setCostAssignmentPolicy(CostAssignmentPolicy policy) {
        this.kp.put((Object)"costAssignmentPolicy", (Object)policy);
    }

    protected boolean shouldProcess(CrawlURI uri) {
        return true;
    }

    protected void innerProcess(CrawlURI curi) {
        this.prepare(curi);
    }

    public void prepare(CrawlURI curi) {
        curi.setSchedulingDirective(this.getSchedulingDirective(curi));
        curi.setCanonicalString(this.canonicalize(curi));
        curi.setClassKey(this.getClassKey(curi));
        curi.setHolderCost(this.getCost(curi));
        this.getUriPrecedencePolicy().uriScheduled(curi);
    }

    protected int getSchedulingDirective(CrawlURI curi) {
        int embedHops;
        char lastHop;
        if (StringUtils.isNotEmpty((String)curi.getPathFromSeed()) && (lastHop = curi.getPathFromSeed().charAt(curi.getPathFromSeed().length() - 1)) == 'R') {
            return this.getPreferenceDepthHops() >= 0 ? 1 : 2;
        }
        if (this.getPreferenceDepthHops() == 0) {
            return 1;
        }
        if (this.getPreferenceDepthHops() > 0 && curi.getPathFromSeed().length() + 1 <= this.getPreferenceDepthHops()) {
            return 1;
        }
        int prefHops = this.getPreferenceEmbedHops();
        if (prefHops > 0 && (embedHops = curi.getTransHops()) > 0 && embedHops <= prefHops && curi.getSchedulingDirective() == 3) {
            return 2;
        }
        return curi.getSchedulingDirective();
    }

    protected String canonicalize(CrawlURI cauri) {
        String canon = this.getCanonicalizationPolicy().canonicalize(cauri.getURI());
        if (cauri.isLocation() && !cauri.toString().equals(cauri.getVia().toString()) && this.getCanonicalizationPolicy().canonicalize(cauri.getVia().toCustomString()).equals(canon)) {
            cauri.setForceFetch(true);
        }
        return canon;
    }

    public String getClassKey(CrawlURI curi) {
        assert (KeyedProperties.overridesActiveFrom((OverlayContext)curi));
        String queueKey = this.getQueueAssignmentPolicy().getClassKey(curi);
        return queueKey;
    }

    protected int getCost(CrawlURI curi) {
        assert (KeyedProperties.overridesActiveFrom((OverlayContext)curi));
        int cost = curi.getHolderCost();
        if (cost == -1) {
            cost = this.getCostAssignmentPolicy().costOf(curi);
        }
        return cost;
    }
}

