/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.archive.crawler.framework.CrawlController;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class LowDiskPauseProcessor
extends Processor {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(LowDiskPauseProcessor.class.getName());
    protected CrawlController controller;
    protected List<String> monitorMounts = new ArrayList<String>();
    protected int pauseThresholdKb = 512000;
    protected int recheckThresholdKb = 204800;
    protected int contentSinceCheck = 0;
    public static final Pattern VALID_DF_OUTPUT = Pattern.compile("(?s)^Filesystem\\s+1K-blocks\\s+Used\\s+Available\\s+Use%\\s+Mounted on\\n.*");
    public static final Pattern AVAILABLE_EXTRACTOR = Pattern.compile("(?m)\\s(\\d+)\\s+\\d+%\\s+(\\S+)$");

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public List<String> getMonitorMounts() {
        return this.monitorMounts;
    }

    public void setMonitorMounts(List<String> monitorMounts) {
        this.monitorMounts = monitorMounts;
    }

    public int getPauseThresholdKb() {
        return this.pauseThresholdKb;
    }

    public void setPauseThresholdKb(int pauseThresholdKb) {
        this.pauseThresholdKb = pauseThresholdKb;
    }

    public int getRecheckThresholdKb() {
        return this.recheckThresholdKb;
    }

    public void setRecheckThresholdKb(int recheckThresholdKb) {
        this.recheckThresholdKb = recheckThresholdKb;
    }

    protected boolean shouldProcess(CrawlURI curi) {
        return true;
    }

    protected void innerProcess(CrawlURI uri) {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessResult innerProcessResult(CrawlURI curi) {
        LowDiskPauseProcessor lowDiskPauseProcessor = this;
        synchronized (lowDiskPauseProcessor) {
            this.contentSinceCheck = (int)((long)this.contentSinceCheck + curi.getContentSize());
            if (this.contentSinceCheck / 1024 > this.getRecheckThresholdKb()) {
                ProcessResult r = this.checkAvailableSpace(curi);
                this.contentSinceCheck = 0;
                return r;
            }
            return ProcessResult.PROCEED;
        }
    }

    private ProcessResult checkAvailableSpace(CrawlURI curi) {
        try {
            String df = IOUtils.toString((InputStream)Runtime.getRuntime().exec("df -k").getInputStream());
            Matcher matcher = VALID_DF_OUTPUT.matcher(df);
            if (!matcher.matches()) {
                logger.severe("'df -k' output unacceptable for low-disk checking");
                return ProcessResult.PROCEED;
            }
            List<String> monitoredMounts = this.getMonitorMounts();
            matcher = AVAILABLE_EXTRACTOR.matcher(df);
            while (matcher.find()) {
                int thresholdKilobytes;
                long availKilobytes;
                String mount = matcher.group(2);
                if (!monitoredMounts.contains(mount) || (availKilobytes = Long.parseLong(matcher.group(1))) >= (long)(thresholdKilobytes = this.getPauseThresholdKb())) continue;
                logger.log(Level.SEVERE, "Low Disk Pause", availKilobytes + "K available on " + mount + " (below threshold " + thresholdKilobytes + "K)");
                this.controller.requestCrawlPause();
                return ProcessResult.PROCEED;
            }
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
        }
        return ProcessResult.PROCEED;
    }
}

