/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.io;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.archive.io.Preformatter;
import org.archive.modules.CoreAttributeConstants;
import org.archive.modules.CrawlURI;
import org.archive.util.ArchiveUtils;
import org.archive.util.MimetypeUtils;

public class UriProcessingFormatter
extends Formatter
implements Preformatter,
CoreAttributeConstants {
    private static final String NA = "-";
    private static final int GUESS_AT_LINE_LENGTH = 1000;
    protected final ThreadLocal<StringBuilder> bufLocal = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(1000);
        }
    };
    protected final ThreadLocal<String> cachedFormat = new ThreadLocal();
    protected boolean logExtraInfo;

    public UriProcessingFormatter(boolean logExtraInfo) {
        this.logExtraInfo = logExtraInfo;
    }

    @Override
    public String format(LogRecord lr) {
        if (this.cachedFormat.get() != null) {
            return this.cachedFormat.get();
        }
        CrawlURI curi = (CrawlURI)lr.getParameters()[0];
        String length = NA;
        String mime = null;
        if (curi.isHttpTransaction()) {
            if (curi.getContentLength() >= 0L) {
                length = Long.toString(curi.getContentLength());
            } else if (curi.getContentSize() > 0L) {
                length = Long.toString(curi.getContentSize());
            }
        } else if (curi.getContentSize() > 0L) {
            length = Long.toString(curi.getContentSize());
        }
        mime = MimetypeUtils.truncate((String)curi.getContentType());
        long time = System.currentTimeMillis();
        String via = curi.flattenVia();
        String digest = curi.getContentDigestSchemeString();
        String sourceTag = curi.containsDataKey("source") ? curi.getSourceTag() : null;
        StringBuilder buffer = this.bufLocal.get();
        buffer.setLength(0);
        buffer.append(ArchiveUtils.getLog17Date((long)time)).append(" ").append(ArchiveUtils.padTo((int)curi.getFetchStatus(), (int)5)).append(" ").append(ArchiveUtils.padTo((String)length, (int)10)).append(" ").append(curi.getUURI().toString()).append(" ").append(this.checkForNull(curi.getPathFromSeed())).append(" ").append(this.checkForNull(via)).append(" ").append(mime).append(" ").append("#").append(ArchiveUtils.padTo((String)Integer.toString(curi.getThreadNumber()), (int)3, (char)'0')).append(" ");
        if (curi.containsDataKey("fetch-completed-time")) {
            long completedTime = curi.getFetchCompletedTime();
            long beganTime = curi.getFetchBeginTime();
            buffer.append(ArchiveUtils.get17DigitDate((long)beganTime)).append("+").append(Long.toString(completedTime - beganTime));
        } else {
            buffer.append(NA);
        }
        buffer.append(" ").append(this.checkForNull(digest)).append(" ").append(this.checkForNull(sourceTag)).append(" ");
        Collection anno = curi.getAnnotations();
        if (anno != null && anno.size() > 0) {
            Iterator iter = anno.iterator();
            buffer.append((String)iter.next());
            while (iter.hasNext()) {
                buffer.append(',');
                buffer.append((String)iter.next());
            }
        } else {
            buffer.append(NA);
        }
        if (this.logExtraInfo) {
            buffer.append(" ").append(curi.getExtraInfo());
        }
        buffer.append("\n");
        return buffer.toString();
    }

    protected String checkForNull(String str) {
        return str == null || str.length() <= 0 ? NA : str;
    }

    public void clear() {
        this.cachedFormat.set(null);
    }

    public void preformat(LogRecord record) {
        this.cachedFormat.set(this.format(record));
    }
}

