/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.LogRecord;
import org.archive.crawler.io.UriProcessingFormatter;
import org.archive.modules.CoreAttributeConstants;
import org.archive.modules.CrawlURI;

public class RuntimeErrorFormatter
extends UriProcessingFormatter
implements CoreAttributeConstants {
    public RuntimeErrorFormatter(boolean logExtraInfo) {
        super(logExtraInfo);
    }

    @Override
    public String format(LogRecord lr) {
        CrawlURI curi;
        Object[] parameters = lr.getParameters();
        String stackTrace = "None retrieved";
        if (parameters != null && (curi = (CrawlURI)parameters[0]) != null) {
            Throwable t = (Throwable)curi.getData().get("runtime-exception");
            assert (t != null) : "Null throwable";
            StringWriter sw = new StringWriter();
            if (t == null) {
                sw.write("No exception to report.");
            } else {
                t.printStackTrace(new PrintWriter(sw));
            }
            stackTrace = sw.toString();
        }
        return super.format(lr) + " " + stackTrace;
    }
}

