/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.BaseQueuePrecedencePolicy;

public class SuccessCountsQueuePrecedencePolicy
extends BaseQueuePrecedencePolicy {
    private static final long serialVersionUID = -4469760728466350850L;

    public SuccessCountsQueuePrecedencePolicy() {
        this.setIncrementCounts("100,1000");
    }

    public String getIncrementCounts() {
        return (String)this.kp.get("incrementCounts");
    }

    public void setIncrementCounts(String counts) {
        this.kp.put((Object)"incrementCounts", (Object)counts);
    }

    @Override
    protected int calculatePrecedence(WorkQueue wq) {
        int precedence = this.getBasePrecedence() - 1;
        Collection increments = CollectionUtils.collect(Arrays.asList(this.getIncrementCounts().split(",")), (Transformer)new Transformer(){

            public Object transform(Object string) {
                return Integer.parseInt((String)string);
            }
        });
        Iterator iter = increments.iterator();
        int increment = (Integer)iter.next();
        long successes = wq.getSubstats().getFetchSuccesses();
        while (successes >= 0L) {
            successes -= (long)increment;
            ++precedence;
            increment = iter.hasNext() ? (Integer)iter.next() : increment;
        }
        return precedence;
    }
}

