/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.archive.modules.recrawl.PersistProcessor;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.bdbje.EnhancedEnvironment;
import org.archive.util.iterator.LineReadingIterator;

public class PrecedenceLoader {
    public static void main(String[] args) throws DatabaseException, IOException {
        if (args.length != 2) {
            System.out.println("Arguments: ");
            System.out.println("    source target");
            System.out.println("...where source is a file of lines 'URI precedence' ");
            System.out.println("and target is a BDB env dir (created if necessary). ");
            return;
        }
        PrecedenceLoader.main2args(args);
    }

    private static void main2args(String[] args) throws DatabaseException, FileNotFoundException, UnsupportedEncodingException, IOException {
        BufferedReader br;
        File source = new File(args[0]);
        File env = new File(args[1]);
        FileUtils.ensureWriteableDirectory((File)env);
        EnhancedEnvironment targetEnv = PersistProcessor.setupCopyEnvironment((File)env);
        StoredClassCatalog classCatalog = targetEnv.getClassCatalog();
        Database historyDB = targetEnv.openDatabase(null, "uri_history", PersistProcessor.HISTORY_DB_CONFIG.toDatabaseConfig());
        StoredSortedMap historyMap = new StoredSortedMap(historyDB, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        int count = 0;
        if (source.isFile()) {
            br = ArchiveUtils.getBufferedReader((File)source);
            LineReadingIterator iter = new LineReadingIterator(br);
            while (iter.hasNext()) {
                String line = (String)iter.next();
                String[] splits = line.split("\\s");
                String uri = splits[0];
                if (!uri.matches("\\w+:.*")) {
                    uri = "http://" + uri;
                }
                String key = PersistProcessor.persistKeyFor((String)uri);
                int precedence = Integer.parseInt(splits[1]);
                HashMap<String, Integer> map = (HashMap<String, Integer>)historyMap.get((Object)key);
                if (map == null) {
                    map = new HashMap<String, Integer>();
                }
                map.put("precalc-precedence", precedence);
                historyMap.put((Object)key, map);
                if (++count % 100000 != 0) continue;
                System.out.print(count + "... ");
            }
        } else {
            System.err.println("unacceptable source file");
            return;
        }
        br.close();
        System.out.println();
        System.out.println(count + " entries loaded");
        historyDB.sync();
        historyDB.close();
        targetEnv.close();
        System.out.println(count + " records imported from " + source + " to BDB env " + env);
    }
}

