/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.PrecedenceProvider;
import org.archive.crawler.frontier.precedence.QueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.SimplePrecedenceProvider;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;

public class BaseQueuePrecedencePolicy
extends QueuePrecedencePolicy
implements HasKeyedProperties {
    private static final long serialVersionUID = 8312032856661175869L;
    protected KeyedProperties kp = new KeyedProperties();

    public BaseQueuePrecedencePolicy() {
        this.setBasePrecedence(3);
    }

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public int getBasePrecedence() {
        return (Integer)this.kp.get("basePrecedence");
    }

    public void setBasePrecedence(int precedence) {
        this.kp.put((Object)"basePrecedence", (Object)precedence);
    }

    @Override
    public void queueCreated(WorkQueue wq) {
        this.installProvider(wq);
    }

    protected void installProvider(WorkQueue wq) {
        SimplePrecedenceProvider precedenceProvider = new SimplePrecedenceProvider(this.calculatePrecedence(wq));
        wq.setPrecedenceProvider(precedenceProvider);
    }

    protected int calculatePrecedence(WorkQueue wq) {
        return this.getBasePrecedence();
    }

    @Override
    public void queueReevaluate(WorkQueue wq) {
        PrecedenceProvider precedenceProvider = wq.getPrecedenceProvider();
        if (precedenceProvider instanceof SimplePrecedenceProvider) {
            ((SimplePrecedenceProvider)precedenceProvider).setPrecedence(this.calculatePrecedence(wq));
        } else {
            this.installProvider(wq);
        }
    }
}

