/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.DatabaseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.iterators.ObjectArrayIterator;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.crawler.event.CrawlURIDispositionEvent;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.framework.ToeThread;
import org.archive.crawler.frontier.AbstractFrontier;
import org.archive.crawler.frontier.DelayedWorkQueue;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.BaseQueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.QueuePrecedencePolicy;
import org.archive.crawler.util.TopNSet;
import org.archive.modules.CrawlURI;
import org.archive.spring.KeyedProperties;
import org.archive.spring.OverlayContext;
import org.archive.spring.OverlayMapsSource;
import org.archive.util.ArchiveUtils;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.ObjectIdentityMemCache;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.AbstractApplicationContext;

public abstract class WorkQueueFrontier
extends AbstractFrontier
implements Closeable,
ApplicationContextAware {
    private static final long serialVersionUID = 570384305871965843L;
    private static final int MAX_QUEUES_TO_HOLD_ALLQUEUES_IN_MEMORY = 3000;
    protected long snoozeLongMs = 300000L;
    private static final Logger logger = Logger.getLogger(WorkQueueFrontier.class.getName());
    protected AbstractApplicationContext appCtx;
    protected int precedenceFloor;
    protected int maxQueuesPerReportCategory;
    protected ObjectIdentityCache<WorkQueue> allQueues;
    protected BlockingQueue<String> readyClassQueues;
    protected Set<WorkQueue> inProcessQueues;
    protected transient DelayQueue<DelayedWorkQueue> snoozedClassQueues;
    protected StoredSortedMap<Long, DelayedWorkQueue> snoozedOverflow;
    protected AtomicInteger snoozedOverflowCount;
    protected static int MAX_SNOOZED_IN_MEMORY = 10000;
    protected StoredSortedMap<Long, CrawlURI> futureUris;
    protected transient TopNSet largestQueues;
    protected int highestPrecedenceWaiting;
    protected UriUniqFilter uriUniqFilter;

    public long getSnoozeLongMs() {
        return this.snoozeLongMs;
    }

    public void setSnoozeLongMs(long snooze) {
        this.snoozeLongMs = snooze;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = (AbstractApplicationContext)applicationContext;
    }

    public int getBalanceReplenishAmount() {
        return (Integer)this.kp.get("balanceReplenishAmount");
    }

    public void setBalanceReplenishAmount(int replenish) {
        this.kp.put((Object)"balanceReplenishAmount", (Object)replenish);
    }

    public int getErrorPenaltyAmount() {
        return (Integer)this.kp.get("errorPenaltyAmount");
    }

    public void setErrorPenaltyAmount(int penalty) {
        this.kp.put((Object)"errorPenaltyAmount", (Object)penalty);
    }

    public long getQueueTotalBudget() {
        return (Long)this.kp.get("queueTotalBudget");
    }

    public void setQueueTotalBudget(long budget) {
        this.kp.put((Object)"queueTotalBudget", (Object)budget);
    }

    public QueuePrecedencePolicy getQueuePrecedencePolicy() {
        return (QueuePrecedencePolicy)this.kp.get("queuePrecedencePolicy");
    }

    public void setQueuePrecedencePolicy(QueuePrecedencePolicy policy) {
        this.kp.put((Object)"queuePrecedencePolicy", (Object)policy);
    }

    public int getPrecedenceFloor() {
        return this.precedenceFloor;
    }

    public void setPrecedenceFloor(int floor) {
        this.precedenceFloor = floor;
    }

    public int getMaxQueuesPerReportCategory() {
        return this.maxQueuesPerReportCategory;
    }

    public void setMaxQueuesPerReportCategory(int max) {
        this.maxQueuesPerReportCategory = max;
    }

    public int getLargestQueuesCount() {
        return this.largestQueues.getMaxSize();
    }

    public void setLargestQueuesCount(int count) {
        this.largestQueues.setMaxSize(count);
    }

    public UriUniqFilter getUriUniqFilter() {
        return this.uriUniqFilter;
    }

    @Autowired
    public void setUriUniqFilter(UriUniqFilter uriUniqFilter) {
        this.uriUniqFilter = uriUniqFilter;
    }

    public WorkQueueFrontier() {
        this.setBalanceReplenishAmount(3000);
        this.setErrorPenaltyAmount(100);
        this.setQueueTotalBudget(-1L);
        this.setQueuePrecedencePolicy(new BaseQueuePrecedencePolicy());
        this.precedenceFloor = 255;
        this.maxQueuesPerReportCategory = 2000;
        this.allQueues = null;
        this.inProcessQueues = Collections.newSetFromMap(new ConcurrentHashMap());
        this.snoozedOverflowCount = new AtomicInteger(0);
        this.largestQueues = new TopNSet(20);
        this.highestPrecedenceWaiting = Integer.MAX_VALUE;
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.uriUniqFilter.setDestination(this);
        super.start();
        try {
            this.initInternalQueues();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void initInternalQueues() throws IOException, DatabaseException {
        this.initOtherQueues();
        if (this.workQueueDataOnDisk() && this.preparer.getQueueAssignmentPolicy().maximumNumberOfKeys() >= 0 && this.preparer.getQueueAssignmentPolicy().maximumNumberOfKeys() <= 3000) {
            this.allQueues = new ObjectIdentityMemCache(701, 0.9f, 100);
        } else {
            this.initAllQueues();
        }
    }

    protected abstract void initAllQueues() throws DatabaseException;

    protected abstract void initOtherQueues() throws DatabaseException;

    @Override
    public void stop() {
        super.stop();
    }

    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
        ArchiveUtils.closeQuietly((Object)this.uriUniqFilter);
        ArchiveUtils.closeQuietly(this.allQueues);
    }

    @Override
    protected void processScheduleAlways(CrawlURI curi) {
        assert (KeyedProperties.overridesActiveFrom((OverlayContext)curi));
        this.prepForFrontier(curi);
        this.sendToQueue(curi);
    }

    @Override
    public void schedule(CrawlURI curi) {
        this.sheetOverlaysManager.applyOverlaysTo(curi);
        try {
            KeyedProperties.loadOverridesFrom((OverlayContext)curi);
            if (curi.getClassKey() == null) {
                this.preparer.prepare(curi);
            }
            this.processScheduleIfUnique(curi);
        }
        finally {
            KeyedProperties.clearOverridesFrom((OverlayContext)curi);
        }
    }

    @Override
    protected void processScheduleIfUnique(CrawlURI curi) {
        assert (KeyedProperties.overridesActiveFrom((OverlayContext)curi));
        String canon = curi.getCanonicalString();
        if (curi.forceFetch()) {
            this.uriUniqFilter.addForce(canon, curi);
        } else {
            this.uriUniqFilter.add(canon, curi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToQueue(CrawlURI curi) {
        WorkQueue wq;
        WorkQueue workQueue = wq = this.getQueueFor(curi.getClassKey());
        synchronized (workQueue) {
            int originalPrecedence = wq.getPrecedence();
            wq.enqueue(this, curi);
            wq.setSessionBudget(this.getBalanceReplenishAmount());
            wq.setTotalBudget(this.getQueueTotalBudget());
            if (!wq.isRetired()) {
                this.incrementQueuedUriCount();
                int currentPrecedence = wq.getPrecedence();
                if (!wq.isManaged() || currentPrecedence < originalPrecedence) {
                    this.deactivateQueue(wq);
                }
            }
            this.doJournalAdded(curi);
            wq.makeDirty();
        }
        this.largestQueues.update(wq.getClassKey(), wq.getCount());
    }

    protected void readyQueue(WorkQueue wq) {
        try {
            this.readyClassQueues.put(wq.getClassKey());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue readied: " + wq.getClassKey());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.err.println("unable to ready queue " + wq);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateQueue(WorkQueue wq) {
        int precedence = wq.getPrecedence();
        WorkQueue workQueue = wq;
        synchronized (workQueue) {
            wq.noteDeactivated();
            this.inProcessQueues.remove(wq);
            if (wq.getCount() == 0L) {
                logger.info("deactivate empty queue? " + wq.getClassKey());
            }
            SortedMap<Integer, Queue<String>> sortedMap = this.getInactiveQueuesByPrecedence();
            synchronized (sortedMap) {
                this.getInactiveQueuesForPrecedence(precedence).add(wq.getClassKey());
                if (wq.getPrecedence() < this.highestPrecedenceWaiting) {
                    this.highestPrecedenceWaiting = wq.getPrecedence();
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue deactivated to p" + precedence + ": " + wq.getClassKey());
            }
        }
    }

    protected Queue<String> getInactiveQueuesForPrecedence(int precedence) {
        SortedMap<Integer, Queue<String>> inactiveQueuesByPrecedence = this.getInactiveQueuesByPrecedence();
        Queue<String> candidate = (Queue<String>)inactiveQueuesByPrecedence.get(precedence);
        if (candidate == null) {
            candidate = this.createInactiveQueueForPrecedence(precedence);
            inactiveQueuesByPrecedence.put(precedence, candidate);
        }
        return candidate;
    }

    protected abstract SortedMap<Integer, Queue<String>> getInactiveQueuesByPrecedence();

    protected abstract Queue<String> createInactiveQueueForPrecedence(int var1);

    protected void retireQueue(WorkQueue wq) {
        this.inProcessQueues.remove(wq);
        this.getRetiredQueues().add(wq.getClassKey());
        this.decrementQueuedCount(wq.getCount());
        wq.setRetired(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "queue retired: " + wq.getClassKey());
        }
    }

    protected abstract Queue<String> getRetiredQueues();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconsiderRetiredQueues() {
        String key = this.getRetiredQueues().poll();
        while (key != null) {
            WorkQueue q = (WorkQueue)this.allQueues.get(key);
            if (q != null) {
                WorkQueue workQueue = q;
                synchronized (workQueue) {
                    this.unretireQueue(q);
                    q.makeDirty();
                }
            }
            key = this.getRetiredQueues().poll();
        }
    }

    private void unretireQueue(WorkQueue q) {
        this.deactivateQueue(q);
        q.setRetired(false);
        this.incrementQueuedUriCount(q.getCount());
    }

    protected abstract WorkQueue getQueueFor(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected CrawlURI findEligibleURI() {
        this.wakeQueues();
        this.checkFutures();
        readyQ = null;
        block11: while (true) {
            block29: {
                block28: {
                    if ((key = (String)this.readyClassQueues.poll()) != null) break block28;
                    if (this.getInactiveQueuesByPrecedence().isEmpty() || this.highestPrecedenceWaiting >= this.getPrecedenceFloor()) break block29;
                    this.activateInactiveQueue();
                    ** GOTO lbl53
                }
                readyQ = this.getQueueFor(key);
                if (readyQ == null) {
                    WorkQueueFrontier.logger.severe("Key " + key + " in readyClassQueues but not allQueues");
                } else {
                    block25: {
                        var3_4 = readyQ;
                        synchronized (var3_4) {
                            if (readyQ.getCount() == 0L) {
                                readyQ.noteExhausted();
                                readyQ.makeDirty();
                                readyQ = null;
                                break block25;
                            }
                            if (!this.inProcessQueues.add(readyQ)) {
                                readyQ = null;
                                break block25;
                            }
                            readyQ.considerActive();
                            readyQ.setWakeTime(0L);
                            readyQUri = readyQ.peek(this);
                            this.sheetOverlaysManager.applyOverlaysTo(readyQUri);
                            try {
                                KeyedProperties.loadOverridesFrom((OverlayContext)readyQUri);
                                readyQ.setSessionBudget(this.getBalanceReplenishAmount());
                                readyQ.setTotalBudget(this.getQueueTotalBudget());
                            }
                            finally {
                                KeyedProperties.clearOverridesFrom((OverlayContext)readyQUri);
                            }
                            if (readyQ.isOverSessionBudget()) {
                                this.deactivateQueue(readyQ);
                                readyQ.makeDirty();
                                readyQ = null;
                            } else {
                                ** if (!readyQ.isOverTotalBudget()) goto lbl50
lbl-1000:
                                // 1 sources

                                {
                                    this.retireQueue((WorkQueue)readyQ);
                                    readyQ.makeDirty();
                                    readyQ = null;
                                    ** GOTO lbl53
                                }
                            }
lbl50:
                            // 1 sources

                        }
                    }
                    if (readyQ == null) continue;
                }
            }
            if (readyQ == null) break;
            do {
                curi = null;
                curi = readyQ.peek(this);
                if (curi == null) {
                    WorkQueueFrontier.logger.severe("No CrawlURI from ready non-empty queue " + readyQ.classKey + "\n" + readyQ.shortReportLegend() + "\n" + readyQ.shortReportLine() + "\n");
                    continue block11;
                }
                curi.setOverlayMapsSource((OverlayMapsSource)this.sheetOverlaysManager);
                this.sheetOverlaysManager.applyOverlaysTo(curi);
                try {
                    KeyedProperties.loadOverridesFrom((OverlayContext)curi);
                    currentQueueKey = this.getClassKey(curi);
                }
                finally {
                    KeyedProperties.clearOverridesFrom((OverlayContext)curi);
                }
                if (currentQueueKey.equals(curi.getClassKey())) {
                    this.noteAboutToEmit(curi, readyQ);
                    return curi;
                }
                readyQ.dequeue(this, curi);
                this.doJournalRelocated(curi);
                curi.setClassKey(currentQueueKey);
                this.decrementQueuedCount(1L);
                curi.setHolderKey(null);
                this.sendToQueue(curi);
            } while (readyQ.getCount() != 0L);
            this.inProcessQueues.remove(readyQ);
            readyQ.noteExhausted();
            readyQ.makeDirty();
            readyQ = null;
        }
        if (this.inProcessQueues.size() == 0) {
            this.uriUniqFilter.requestFlush();
        }
        if (this.getTotalEligibleInactiveQueues() == 0) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException var2_3) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFutures() {
        if (!this.futureUris.isEmpty()) {
            StoredSortedMap<Long, CrawlURI> storedSortedMap = this.futureUris;
            synchronized (storedSortedMap) {
                Iterator iter = this.futureUris.headMap((Object)System.currentTimeMillis()).values().iterator();
                while (iter.hasNext()) {
                    CrawlURI curi = (CrawlURI)iter.next();
                    curi.setRescheduleTime(-1L);
                    iter.remove();
                    this.futureUriCount.decrementAndGet();
                    this.receive(curi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean activateInactiveQueue() {
        block8: for (Map.Entry<Integer, Queue<String>> entry : this.getInactiveQueuesByPrecedence().entrySet()) {
            String workQueueKey;
            int expectedPrecedence = entry.getKey();
            Queue<String> queueOfWorkQueueKeys = entry.getValue();
            while (true) {
                SortedMap<Integer, Queue<String>> sortedMap = this.getInactiveQueuesByPrecedence();
                synchronized (sortedMap) {
                    workQueueKey = queueOfWorkQueueKeys.poll();
                    if (workQueueKey == null) {
                        continue block8;
                    }
                    this.updateHighestWaiting(expectedPrecedence);
                }
                WorkQueue candidateQ = (WorkQueue)this.allQueues.get(workQueueKey);
                if (candidateQ.getPrecedence() <= expectedPrecedence) break;
                WorkQueue workQueue = candidateQ;
                synchronized (workQueue) {
                    this.deactivateQueue(candidateQ);
                    candidateQ.makeDirty();
                }
            }
            try {
                this.readyClassQueues.put(workQueueKey);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    protected void updateHighestWaiting(int startFrom) {
        for (int precedenceKey : this.getInactiveQueuesByPrecedence().tailMap(startFrom).keySet()) {
            if (((Queue)this.getInactiveQueuesByPrecedence().get(precedenceKey)).isEmpty()) continue;
            this.highestPrecedenceWaiting = precedenceKey;
            return;
        }
        this.highestPrecedenceWaiting = Integer.MAX_VALUE;
    }

    protected void reenqueueQueue(WorkQueue wq) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("queue reenqueued: " + wq.getClassKey());
        }
        if (this.highestPrecedenceWaiting < wq.getPrecedence() || wq.getPrecedence() >= this.getPrecedenceFloor()) {
            this.deactivateQueue(wq);
        } else {
            this.readyQueue(wq);
        }
    }

    @Override
    protected long getMaxInWait() {
        Object next = this.snoozedClassQueues.peek();
        return next == null ? 60000L : next.getDelay(TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceWakeQueues() {
        Iterator<DelayedWorkQueue> iterSnoozed = this.snoozedClassQueues.iterator();
        while (iterSnoozed.hasNext()) {
            WorkQueue queue;
            WorkQueue workQueue = queue = iterSnoozed.next().getWorkQueue(this);
            synchronized (workQueue) {
                queue.setWakeTime(0L);
                this.reenqueueQueue(queue);
                queue.makeDirty();
            }
            iterSnoozed.remove();
        }
        Iterator iterOverflow = this.snoozedOverflow.values().iterator();
        while (iterOverflow.hasNext()) {
            WorkQueue queue;
            WorkQueue workQueue = queue = ((DelayedWorkQueue)iterOverflow.next()).getWorkQueue(this);
            synchronized (workQueue) {
                queue.setWakeTime(0L);
                this.reenqueueQueue(queue);
                queue.makeDirty();
            }
            iterOverflow.remove();
            this.snoozedOverflowCount.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeQueues() {
        DelayedWorkQueue waked;
        while ((waked = (DelayedWorkQueue)this.snoozedClassQueues.poll()) != null) {
            WorkQueue queue;
            WorkQueue workQueue = queue = waked.getWorkQueue(this);
            synchronized (workQueue) {
                queue.setWakeTime(0L);
                queue.makeDirty();
            }
            this.reenqueueQueue(queue);
        }
        if (!this.snoozedOverflow.isEmpty()) {
            StoredSortedMap<Long, DelayedWorkQueue> storedSortedMap = this.snoozedOverflow;
            synchronized (storedSortedMap) {
                Iterator iter = this.snoozedOverflow.headMap((Object)System.currentTimeMillis()).values().iterator();
                while (iter.hasNext()) {
                    WorkQueue queue;
                    DelayedWorkQueue dq = (DelayedWorkQueue)iter.next();
                    iter.remove();
                    this.snoozedOverflowCount.decrementAndGet();
                    WorkQueue workQueue = queue = dq.getWorkQueue(this);
                    synchronized (workQueue) {
                        queue.setWakeTime(0L);
                        queue.makeDirty();
                    }
                    this.reenqueueQueue(queue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFinish(CrawlURI curi) {
        WorkQueue wq;
        long now = System.currentTimeMillis();
        curi.incrementFetchAttempts();
        this.logNonfatalErrors(curi);
        WorkQueue workQueue = wq = (WorkQueue)curi.getHolder();
        synchronized (workQueue) {
            wq.setSessionBudget(this.getBalanceReplenishAmount());
            wq.setTotalBudget(this.getQueueTotalBudget());
            assert (wq.peek(this) == curi) : "unexpected peek " + wq;
            int holderCost = curi.getHolderCost();
            if (this.needsReenqueuing(curi)) {
                if (curi.getFetchStatus() != -50) {
                    wq.expend(holderCost);
                }
                long delay_ms = this.retryDelayFor(curi) * 1000L;
                curi.processingCleanup();
                wq.unpeek(curi);
                wq.update(this, curi);
                this.handleQueue(wq, curi.includesRetireDirective(), now, delay_ms);
                this.appCtx.publishEvent((ApplicationEvent)new CrawlURIDispositionEvent(this, curi, CrawlURIDispositionEvent.Disposition.DEFERRED_FOR_RETRY));
                this.doJournalReenqueued(curi);
                wq.makeDirty();
                return;
            }
            wq.dequeue(this, curi);
            this.decrementQueuedCount(1L);
            this.largestQueues.update(wq.getClassKey(), wq.getCount());
            this.log(curi);
            if (curi.isSuccess()) {
                this.incrementSucceededFetchCount();
                this.totalProcessedBytes.addAndGet(curi.getRecordedSize());
                this.appCtx.publishEvent((ApplicationEvent)new CrawlURIDispositionEvent(this, curi, CrawlURIDispositionEvent.Disposition.SUCCEEDED));
                this.doJournalFinishedSuccess(curi);
            } else if (this.isDisregarded(curi)) {
                this.incrementDisregardedUriCount();
                this.appCtx.publishEvent((ApplicationEvent)new CrawlURIDispositionEvent(this, curi, CrawlURIDispositionEvent.Disposition.DISREGARDED));
                holderCost = 0;
                this.doJournalDisregarded(curi);
            } else {
                this.incrementFailedFetchCount();
                this.appCtx.publishEvent((ApplicationEvent)new CrawlURIDispositionEvent(this, curi, CrawlURIDispositionEvent.Disposition.FAILED));
                if (curi.getFetchStatus() == -5) {
                    Object[] array = new Object[]{curi};
                    this.loggerModule.getRuntimeErrors().log(Level.WARNING, curi.getUURI().toString(), array);
                }
                wq.noteError(this.getErrorPenaltyAmount());
                this.doJournalFinishedFailure(curi);
            }
            wq.expend(holderCost);
            long delay_ms = curi.getPolitenessDelay();
            this.handleQueue(wq, curi.includesRetireDirective(), now, delay_ms);
            wq.makeDirty();
        }
        if (curi.getRescheduleTime() > 0L) {
            curi.processingCleanup();
            curi.resetForRescheduling();
            this.futureUris.put((Object)curi.getRescheduleTime(), (Object)curi);
            this.futureUriCount.incrementAndGet();
        } else {
            curi.stripToMinimal();
            curi.processingCleanup();
        }
    }

    protected void handleQueue(WorkQueue wq, boolean forceRetire, long now, long delay_ms) {
        this.inProcessQueues.remove(wq);
        if (forceRetire) {
            this.retireQueue(wq);
        } else if (delay_ms > 0L) {
            this.snoozeQueue(wq, now, delay_ms);
        } else {
            this.getQueuePrecedencePolicy().queueReevaluate(wq);
            this.reenqueueQueue(wq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void snoozeQueue(WorkQueue wq, long now, long delay_ms) {
        long nextTime = now + delay_ms;
        wq.setWakeTime(nextTime);
        DelayedWorkQueue dq = new DelayedWorkQueue(wq);
        if (this.snoozedClassQueues.size() < MAX_SNOOZED_IN_MEMORY) {
            this.snoozedClassQueues.add(dq);
        } else {
            StoredSortedMap<Long, DelayedWorkQueue> storedSortedMap = this.snoozedOverflow;
            synchronized (storedSortedMap) {
                this.snoozedOverflow.put((Object)nextTime, (Object)dq);
                this.snoozedOverflowCount.incrementAndGet();
            }
        }
    }

    protected void forget(CrawlURI curi) {
        logger.finer("Forgetting " + curi);
        this.uriUniqFilter.forget(curi.getCanonicalString(), curi);
    }

    @Override
    public long discoveredUriCount() {
        return this.uriUniqFilter != null ? this.uriUniqFilter.count() : 0L;
    }

    public long candidateUriCount() {
        return this.uriUniqFilter != null ? this.uriUniqFilter.addedCount() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long deleteURIs(String queueRegex, String uriRegex) {
        long count = 0L;
        Pattern queuePat = Pattern.compile(queueRegex);
        for (String qname : this.allQueues.keySet()) {
            WorkQueue wq;
            if (!queuePat.matcher(qname).matches()) continue;
            WorkQueue workQueue = wq = this.getQueueFor(qname);
            synchronized (workQueue) {
                wq.unpeek(null);
                long delCount = wq.deleteMatching(this, uriRegex);
                if (!wq.isRetired()) {
                    count += delCount;
                }
                wq.makeDirty();
            }
        }
        this.decrementQueuedCount(count);
        return count;
    }

    public Map<String, Object> shortReportMap() {
        if (this.allQueues == null) {
            return null;
        }
        int allCount = this.allQueues.size();
        int inProcessCount = this.inProcessQueues.size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.getSnoozedCount();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int inactiveCount = this.getTotalEligibleInactiveQueues();
        int ineligibleCount = this.getTotalIneligibleInactiveQueues();
        int retiredCount = this.getRetiredQueues().size();
        int exhaustedCount = allCount - activeCount - inactiveCount - retiredCount;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("totalQueues", allCount);
        map.put("inProcessQueues", inProcessCount);
        map.put("readyQueues", readyCount);
        map.put("snoozedQueues", snoozedCount);
        map.put("activeQueues", activeCount);
        map.put("inactiveQueues", inactiveCount);
        map.put("ineligibleQueues", ineligibleCount);
        map.put("retiredQueues", retiredCount);
        map.put("exhaustedQueues", exhaustedCount);
        map.put("lastReachedState", (Object)this.lastReachedState);
        map.put("queueReadiedCount", this.queueReadiedCount.get());
        return map;
    }

    public void shortReportLineTo(PrintWriter w) {
        if (!this.isRunning()) {
            return;
        }
        if (this.allQueues == null) {
            return;
        }
        int allCount = this.allQueues.size();
        int inProcessCount = this.inProcessQueues.size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.getSnoozedCount();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int inactiveCount = this.getTotalEligibleInactiveQueues();
        int ineligibleCount = this.getTotalIneligibleInactiveQueues();
        int retiredCount = this.getRetiredQueues().size();
        int exhaustedCount = allCount - activeCount - inactiveCount - retiredCount;
        Frontier.State last = this.lastReachedState;
        w.print((Object)last);
        w.print(" - ");
        w.print(allCount);
        w.print(" URI queues: ");
        w.print(activeCount);
        w.print(" active (");
        w.print(inProcessCount);
        w.print(" in-process; ");
        w.print(readyCount);
        w.print(" ready; ");
        w.print(snoozedCount);
        w.print(" snoozed); ");
        w.print(inactiveCount);
        w.print(" inactive; ");
        w.print(ineligibleCount);
        w.print(" ineligible; ");
        w.print(retiredCount);
        w.print(" retired; ");
        w.print(exhaustedCount);
        w.print(" exhausted");
        w.flush();
    }

    protected int getTotalInactiveQueues() {
        return this.tallyInactiveTotals(this.getInactiveQueuesByPrecedence());
    }

    protected int getTotalEligibleInactiveQueues() {
        return this.tallyInactiveTotals(this.getInactiveQueuesByPrecedence().headMap(this.getPrecedenceFloor()));
    }

    protected int getTotalIneligibleInactiveQueues() {
        return this.tallyInactiveTotals(this.getInactiveQueuesByPrecedence().tailMap(this.getPrecedenceFloor()));
    }

    private int tallyInactiveTotals(SortedMap<Integer, Queue<String>> iqueues) {
        int inactiveCount = 0;
        for (Queue<String> q : iqueues.values()) {
            inactiveCount += q.size();
        }
        return inactiveCount;
    }

    public String shortReportLegend() {
        return "total active in-process ready snoozed inactive retired exhausted";
    }

    public synchronized void reportTo(PrintWriter writer) {
        int allCount = this.allQueues.size();
        int inProcessCount = this.inProcessQueues.size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.getSnoozedCount();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int inactiveCount = this.getTotalInactiveQueues();
        int retiredCount = this.getRetiredQueues().size();
        int exhaustedCount = allCount - activeCount - inactiveCount - retiredCount;
        writer.print("Frontier report - ");
        writer.print(ArchiveUtils.get12DigitDate());
        writer.print("\n");
        writer.print(" Job being crawled: ");
        writer.print(this.controller.getMetadata().getJobName());
        writer.print("\n");
        writer.print("\n -----===== STATS =====-----\n");
        writer.print(" Discovered:    ");
        writer.print(Long.toString(this.discoveredUriCount()));
        writer.print("\n");
        writer.print(" Queued:        ");
        writer.print(Long.toString(this.queuedUriCount()));
        writer.print("\n");
        writer.print(" Finished:      ");
        writer.print(Long.toString(this.finishedUriCount()));
        writer.print("\n");
        writer.print("  Successfully: ");
        writer.print(Long.toString(this.succeededFetchCount()));
        writer.print("\n");
        writer.print("  Failed:       ");
        writer.print(Long.toString(this.failedFetchCount()));
        writer.print("\n");
        writer.print("  Disregarded:  ");
        writer.print(Long.toString(this.disregardedUriCount()));
        writer.print("\n");
        writer.print("\n -----===== QUEUES =====-----\n");
        writer.print(" Already included size:     ");
        writer.print(Long.toString(this.uriUniqFilter.count()));
        writer.print("\n");
        writer.print("               pending:     ");
        writer.print(Long.toString(this.uriUniqFilter.pending()));
        writer.print("\n");
        writer.print("\n All class queues map size: ");
        writer.print(Long.toString(allCount));
        writer.print("\n");
        writer.print("             Active queues: ");
        writer.print(activeCount);
        writer.print("\n");
        writer.print("                    In-process: ");
        writer.print(inProcessCount);
        writer.print("\n");
        writer.print("                         Ready: ");
        writer.print(readyCount);
        writer.print("\n");
        writer.print("                       Snoozed: ");
        writer.print(snoozedCount);
        writer.print("\n");
        writer.print("           Inactive queues: ");
        writer.print(inactiveCount);
        writer.print(" (");
        SortedMap<Integer, Queue<String>> inactives = this.getInactiveQueuesByPrecedence();
        boolean betwixt = false;
        for (Integer k : inactives.keySet()) {
            if (betwixt) {
                writer.print("; ");
            }
            writer.print("p");
            writer.print(k);
            writer.print(": ");
            writer.print(((Queue)inactives.get(k)).size());
            betwixt = true;
        }
        writer.print(")\n");
        writer.print("            Retired queues: ");
        writer.print(retiredCount);
        writer.print("\n");
        writer.print("          Exhausted queues: ");
        writer.print(exhaustedCount);
        writer.print("\n");
        Frontier.State last = this.lastReachedState;
        writer.print("\n             Last state: " + (Object)((Object)last));
        writer.print("\n -----===== MANAGER THREAD =====-----\n");
        ToeThread.reportThread(this.managerThread, writer);
        writer.print("\n -----===== " + this.largestQueues.size() + " LONGEST QUEUES =====-----\n");
        this.appendQueueReports(writer, "LONGEST", this.largestQueues.getEntriesDescending().iterator(), this.largestQueues.size(), this.largestQueues.size());
        writer.print("\n -----===== IN-PROCESS QUEUES =====-----\n");
        Set<WorkQueue> inProcess = this.inProcessQueues;
        ArrayList<WorkQueue> copy = WorkQueueFrontier.extractSome(inProcess, this.maxQueuesPerReportCategory);
        this.appendQueueReports(writer, "IN-PROCESS", copy.iterator(), copy.size(), this.maxQueuesPerReportCategory);
        writer.print("\n -----===== READY QUEUES =====-----\n");
        this.appendQueueReports(writer, "READY", this.readyClassQueues.iterator(), this.readyClassQueues.size(), this.maxQueuesPerReportCategory);
        writer.print("\n -----===== SNOOZED QUEUES =====-----\n");
        Object[] objs = this.snoozedClassQueues.toArray();
        Object[] qs = (DelayedWorkQueue[])Arrays.copyOf(objs, objs.length, DelayedWorkQueue[].class);
        Arrays.sort(qs);
        this.appendQueueReports(writer, "SNOOZED", (Iterator<?>)new ObjectArrayIterator(qs), this.getSnoozedCount(), this.maxQueuesPerReportCategory);
        writer.print("\n -----===== INACTIVE QUEUES =====-----\n");
        SortedMap<Integer, Queue<String>> sortedInactives = this.getInactiveQueuesByPrecedence();
        for (Integer prec : sortedInactives.keySet()) {
            Queue inactiveQueues = (Queue)sortedInactives.get(prec);
            this.appendQueueReports(writer, "INACTIVE-p" + prec, inactiveQueues.iterator(), inactiveQueues.size(), this.maxQueuesPerReportCategory);
        }
        writer.print("\n -----===== RETIRED QUEUES =====-----\n");
        this.appendQueueReports(writer, "RETIRED", this.getRetiredQueues().iterator(), this.getRetiredQueues().size(), this.maxQueuesPerReportCategory);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNonemptyReportTo(PrintWriter writer) {
        ArrayList<WorkQueue> inProcessQueuesCopy;
        Set<WorkQueue> set = this.inProcessQueues;
        synchronized (set) {
            Set<WorkQueue> set2 = this.inProcessQueues;
            inProcessQueuesCopy = new ArrayList<WorkQueue>(set2);
        }
        writer.print("\n -----===== IN-PROCESS QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, inProcessQueuesCopy.iterator());
        writer.print("\n -----===== READY QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, this.readyClassQueues.iterator());
        writer.print("\n -----===== SNOOZED QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, this.snoozedClassQueues.iterator());
        this.queueSingleLinesTo(writer, this.snoozedOverflow.values().iterator());
        writer.print("\n -----===== INACTIVE QUEUES =====-----\n");
        for (Queue queue : this.getInactiveQueuesByPrecedence().values()) {
            this.queueSingleLinesTo(writer, queue.iterator());
        }
        writer.print("\n -----===== RETIRED QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, this.getRetiredQueues().iterator());
    }

    public void allQueuesReportTo(PrintWriter writer) {
        this.queueSingleLinesTo(writer, this.allQueues.keySet().iterator());
    }

    private void queueSingleLinesTo(PrintWriter writer, Iterator<?> iterator) {
        boolean legendWritten = false;
        while (iterator.hasNext()) {
            WorkQueue q;
            Object obj = iterator.next();
            if (obj == null) continue;
            if (obj instanceof WorkQueue) {
                q = (WorkQueue)obj;
            } else if (obj instanceof DelayedWorkQueue) {
                q = ((DelayedWorkQueue)obj).getWorkQueue(this);
            } else {
                try {
                    q = (WorkQueue)this.allQueues.get((String)obj);
                }
                catch (ClassCastException cce) {
                    logger.log(Level.SEVERE, "not convertible to workqueue:" + obj, cce);
                    q = null;
                }
            }
            if (q != null) {
                if (!legendWritten) {
                    writer.println(q.shortReportLegend());
                    legendWritten = true;
                }
                q.shortReportLineTo(writer);
                continue;
            }
            writer.print(" ERROR: " + obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ArrayList<T> extractSome(Collection<T> c, int max) {
        int initial = Math.min(c.size() + 10, max);
        ArrayList<T> list = new ArrayList<T>(initial);
        Collection<T> collection = c;
        synchronized (collection) {
            Iterator<T> iter = c.iterator();
            for (int count = 0; iter.hasNext() && count < max; ++count) {
                list.add(iter.next());
            }
        }
        return list;
    }

    protected void appendQueueReports(PrintWriter w, String label, Iterator<?> iterator, int total, int max) {
        int count;
        for (count = 0; iterator.hasNext() && count < max; ++count) {
            Object obj = iterator.next();
            if (obj == null) continue;
            WorkQueue q = obj instanceof WorkQueue ? (WorkQueue)obj : (obj instanceof DelayedWorkQueue ? ((DelayedWorkQueue)obj).getWorkQueue(this) : (obj instanceof Map.Entry ? (WorkQueue)this.allQueues.get((String)((Map.Entry)obj).getKey()) : (WorkQueue)this.allQueues.get((String)obj)));
            if (q != null) {
                w.println(label + "#" + count + ":");
                q.reportTo(w);
                continue;
            }
            w.print("WARNING: No report for queue " + obj);
        }
        if (++count < total) {
            w.print("...and " + (total - count) + " more " + label + ".\n");
        }
    }

    @Override
    public void deleted(CrawlURI curi) {
        this.appCtx.publishEvent((ApplicationEvent)new CrawlURIDispositionEvent(this, curi, CrawlURIDispositionEvent.Disposition.DISREGARDED));
        this.log(curi);
        this.incrementDisregardedUriCount();
        curi.stripToMinimal();
        curi.processingCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void considerIncluded(CrawlURI curi) {
        this.sheetOverlaysManager.applyOverlaysTo(curi);
        if (curi.getClassKey() == null) {
            this.preparer.prepare(curi);
        }
        this.uriUniqFilter.note(curi.getCanonicalString());
        try {
            WorkQueue wq;
            KeyedProperties.loadOverridesFrom((OverlayContext)curi);
            curi.setClassKey(this.getClassKey(curi));
            WorkQueue workQueue = wq = this.getQueueFor(curi.getClassKey());
            synchronized (workQueue) {
                wq.expend(curi.getHolderCost());
                wq.makeDirty();
            }
        }
        finally {
            KeyedProperties.clearOverridesFrom((OverlayContext)curi);
        }
    }

    protected abstract boolean workQueueDataOnDisk();

    @Override
    public long averageDepth() {
        int inactiveCount;
        int snoozedCount;
        int readyCount;
        if (this.inProcessQueues == null || this.readyClassQueues == null || this.snoozedClassQueues == null) {
            return 0L;
        }
        int inProcessCount = this.inProcessQueues.size();
        int activeCount = inProcessCount + (readyCount = this.readyClassQueues.size()) + (snoozedCount = this.getSnoozedCount());
        int totalQueueCount = activeCount + (inactiveCount = this.getTotalInactiveQueues());
        return totalQueueCount == 0 ? 0L : this.queuedUriCount.get() / (long)totalQueueCount;
    }

    protected int getSnoozedCount() {
        return this.snoozedClassQueues.size() + this.snoozedOverflowCount.get();
    }

    @Override
    public float congestionRatio() {
        if (this.inProcessQueues == null || this.readyClassQueues == null || this.snoozedClassQueues == null) {
            return 0.0f;
        }
        int inProcessCount = this.inProcessQueues.size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.getSnoozedCount();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int eligibleInactiveCount = this.getTotalEligibleInactiveQueues();
        return (float)(activeCount + eligibleInactiveCount) / (float)(inProcessCount + snoozedCount);
    }

    @Override
    public long deepestUri() {
        return this.largestQueues.getTopSet().size() == 0 ? -1L : (Long)this.largestQueues.getTopSet().get(this.largestQueues.getLargest());
    }

    @Override
    public boolean isEmpty() {
        return this.queuedUriCount.get() == 0L && (this.uriUniqFilter == null || this.uriUniqFilter.pending() == 0L) && this.futureUriCount.get() == 0L;
    }

    @Override
    protected int getInProcessCount() {
        return this.inProcessQueues.size();
    }
}

