/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.frontier.WorkQueueFrontier;
import org.archive.crawler.frontier.precedence.PrecedenceProvider;
import org.archive.crawler.frontier.precedence.SimplePrecedenceProvider;
import org.archive.modules.CrawlURI;
import org.archive.modules.fetcher.FetchStats;
import org.archive.util.ArchiveUtils;
import org.archive.util.IdentityCacheable;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.ReportUtils;
import org.archive.util.Reporter;

public abstract class WorkQueue
implements Frontier.FrontierGroup,
Serializable,
Reporter,
Delayed,
IdentityCacheable {
    private static final long serialVersionUID = -3199666138837266341L;
    private static final Logger logger = Logger.getLogger(WorkQueue.class.getName());
    protected final String classKey;
    protected boolean active = false;
    protected long count = 0L;
    protected long enqueueCount = 0L;
    protected boolean isManaged = false;
    protected long wakeTime = 0L;
    protected PrecedenceProvider precedenceProvider = new SimplePrecedenceProvider(1);
    protected int sessionBudget = 0;
    protected int lastCost = 0;
    protected long costCount = 0L;
    protected long totalExpenditure = 0L;
    protected long expenditureAtLastActivation = 0L;
    protected long totalBudget = 0L;
    protected transient CrawlURI peekItem = null;
    protected String lastQueued;
    protected String lastPeeked;
    protected long lastDequeueTime;
    protected long errorCount = 0L;
    protected FetchStats substats = new FetchStats();
    protected boolean retired;
    private transient ObjectIdentityCache<?> cache;

    public WorkQueue(String pClassKey) {
        this.classKey = pClassKey;
    }

    public synchronized long deleteMatching(WorkQueueFrontier frontier, String match) {
        try {
            long deleteCount = this.deleteMatchingFromQueue(frontier, match);
            this.count -= deleteCount;
            return deleteCount;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected synchronized long enqueue(WorkQueueFrontier frontier, CrawlURI curi) {
        try {
            this.insert(frontier, curi, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ++this.count;
        ++this.enqueueCount;
        return this.count;
    }

    public synchronized CrawlURI peek(WorkQueueFrontier frontier) {
        if (this.peekItem == null && this.count > 0L) {
            try {
                this.peekItem = this.peekItem(frontier);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "peek failure", e);
                e.printStackTrace();
            }
            if (this.peekItem != null) {
                this.lastPeeked = this.peekItem.toString();
            }
        }
        return this.peekItem;
    }

    protected synchronized void dequeue(WorkQueueFrontier frontier, CrawlURI expected) {
        try {
            this.deleteItem(frontier, this.peekItem);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.unpeek(expected);
        --this.count;
        this.lastDequeueTime = System.currentTimeMillis();
    }

    protected void setSessionBudget(int budget) {
        this.sessionBudget = budget;
    }

    public int getSessionBudget() {
        return this.sessionBudget;
    }

    public synchronized void considerActive() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.expenditureAtLastActivation = this.totalExpenditure;
    }

    protected void setTotalBudget(long budget) {
        this.totalBudget = budget;
    }

    public boolean isOverSessionBudget() {
        return this.sessionBudget > 0 && this.totalExpenditure - this.expenditureAtLastActivation > (long)this.sessionBudget;
    }

    public boolean isOverTotalBudget() {
        return this.totalBudget >= 0L && this.totalExpenditure >= this.totalBudget;
    }

    public long getTotalExpenditure() {
        return this.totalExpenditure;
    }

    public void expend(int amount) {
        this.totalExpenditure += (long)amount;
        if (amount >= 0) {
            this.lastCost = amount;
            ++this.costCount;
        } else {
            --this.costCount;
        }
    }

    public void noteError(int penalty) {
        this.totalExpenditure += (long)penalty;
        ++this.errorCount;
    }

    public void setWakeTime(long l) {
        this.wakeTime = l;
    }

    public long getWakeTime() {
        return this.wakeTime;
    }

    public String getClassKey() {
        return this.classKey;
    }

    public synchronized void unpeek(CrawlURI expected) {
        assert (expected == this.peekItem) : "unexpected peekItem";
        this.peekItem = null;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getWakeTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final int compareTo(Delayed obj) {
        if (this == obj) {
            return 0;
        }
        WorkQueue other = (WorkQueue)obj;
        if (this.getWakeTime() > other.getWakeTime()) {
            return 1;
        }
        if (this.getWakeTime() < other.getWakeTime()) {
            return -1;
        }
        return this.classKey.compareTo(other.getClassKey());
    }

    protected void update(WorkQueueFrontier frontier, CrawlURI curi) {
        try {
            this.insert(frontier, curi, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    private void insert(WorkQueueFrontier frontier, CrawlURI curi, boolean overwriteIfPresent) throws IOException {
        this.insertItem(frontier, curi, overwriteIfPresent);
        this.lastQueued = curi.toString();
    }

    protected abstract void insertItem(WorkQueueFrontier var1, CrawlURI var2, boolean var3) throws IOException;

    protected abstract long deleteMatchingFromQueue(WorkQueueFrontier var1, String var2) throws IOException;

    protected abstract void deleteItem(WorkQueueFrontier var1, CrawlURI var2) throws IOException;

    protected abstract CrawlURI peekItem(WorkQueueFrontier var1) throws IOException;

    public synchronized Map<String, Object> shortReportMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueName", this.classKey);
        map.put("precedence", this.getPrecedence());
        map.put("itemCount", this.count);
        map.put("enqueueCount", this.enqueueCount);
        map.put("sessionBalance", this.getSessionBalance());
        map.put("lastCost", this.lastCost);
        map.put("averageCost", (double)this.totalExpenditure / (double)this.costCount);
        if (this.lastDequeueTime != 0L) {
            map.put("lastDequeueTime", new Date(this.lastDequeueTime));
        } else {
            map.put("lastDequeueTime", null);
        }
        if (this.wakeTime != 0L) {
            map.put("lastDequeueTime", new Date(this.wakeTime));
        } else {
            map.put("lastDequeueTime", null);
        }
        map.put("totalExpenditure", this.totalExpenditure);
        map.put("totalBudget", this.totalBudget);
        map.put("errorCount", this.errorCount);
        map.put("lastPeeked", this.lastPeeked);
        map.put("lastQueued", this.lastQueued);
        return map;
    }

    protected long getSessionBalance() {
        return (long)this.sessionBudget - (this.totalExpenditure - this.expenditureAtLastActivation);
    }

    public synchronized void shortReportLineTo(PrintWriter writer) {
        writer.print(this.classKey);
        writer.print(" ");
        writer.print(this.getPrecedence());
        writer.print(" ");
        writer.print(Long.toString(this.count));
        writer.print(" ");
        writer.print(Long.toString(this.enqueueCount));
        writer.print(" ");
        writer.print(this.getSessionBalance());
        writer.print(" ");
        writer.print(this.lastCost);
        writer.print("(");
        writer.print(ArchiveUtils.doubleToString((double)((double)this.totalExpenditure / (double)this.costCount), (int)1));
        writer.print(")");
        writer.print(" ");
        if (this.lastDequeueTime != 0L) {
            writer.print(ArchiveUtils.getLog17Date((long)this.lastDequeueTime));
        } else {
            writer.print("-");
        }
        writer.print(" ");
        if (this.wakeTime != 0L) {
            writer.print(ArchiveUtils.formatMillisecondsToConventional((long)(this.wakeTime - System.currentTimeMillis())));
        } else {
            writer.print("-");
        }
        writer.print(" ");
        writer.print(Long.toString(this.totalExpenditure));
        writer.print("/");
        writer.print(Long.toString(this.totalBudget));
        writer.print(" ");
        writer.print(Long.toString(this.errorCount));
        writer.print(" ");
        writer.print(this.lastPeeked);
        writer.print(" ");
        writer.print(this.lastQueued);
        writer.print("\n");
    }

    public String shortReportLegend() {
        return "queue precedence currentSize totalEnqueues sessionBalance lastCost (averageCost) lastDequeueTime wakeTime totalSpend/totalBudget errorCount lastPeekUri lastQueuedUri";
    }

    public String shortReportLine() {
        return ReportUtils.shortReportLine((Reporter)this);
    }

    public synchronized void reportTo(PrintWriter writer) {
        writer.print("Queue ");
        writer.print(this.classKey);
        writer.print(" (p");
        writer.print(this.getPrecedence());
        writer.print(")\n");
        writer.print("  ");
        writer.print(Long.toString(this.count));
        writer.print(" items");
        if (this.wakeTime != 0L) {
            writer.print("\n   wakes in: " + ArchiveUtils.formatMillisecondsToConventional((long)(this.wakeTime - System.currentTimeMillis())));
        }
        writer.print("\n    last enqueued: ");
        writer.print(this.lastQueued);
        writer.print("\n      last peeked: ");
        writer.print(this.lastPeeked);
        writer.print("\n");
        writer.print("   total expended: ");
        writer.print(Long.toString(this.totalExpenditure));
        writer.print(" (total budget: ");
        writer.print(Long.toString(this.totalBudget));
        writer.print(")\n");
        writer.print("   active balance: ");
        writer.print(this.getSessionBalance());
        writer.print("\n   last(avg) cost: ");
        writer.print(this.lastCost);
        writer.print("(");
        writer.print(ArchiveUtils.doubleToString((double)((double)this.totalExpenditure / (double)this.costCount), (int)1));
        writer.print(")\n   ");
        writer.print(this.getSubstats().shortReportLegend());
        writer.print("\n   ");
        writer.print(this.getSubstats().shortReportLine());
        writer.print("\n   ");
        writer.print(this.getPrecedenceProvider().shortReportLegend());
        writer.print("\n   ");
        writer.print(this.getPrecedenceProvider().shortReportLine());
        writer.print("\n\n");
    }

    public FetchStats getSubstats() {
        return this.substats;
    }

    protected void setRetired(boolean b) {
        this.retired = b;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public PrecedenceProvider getPrecedenceProvider() {
        return this.precedenceProvider;
    }

    public void setPrecedenceProvider(PrecedenceProvider precedenceProvider) {
        this.precedenceProvider = precedenceProvider;
    }

    public int getPrecedence() {
        return this.precedenceProvider.getPrecedence();
    }

    public void tally(CrawlURI curi, FetchStats.Stage stage) {
        this.substats.tally(curi, stage);
        this.precedenceProvider.tally(curi, stage);
    }

    public synchronized void noteDeactivated() {
        this.active = false;
        this.isManaged = true;
        this.makeDirty();
    }

    public synchronized void noteExhausted() {
        this.active = false;
        this.isManaged = false;
        this.makeDirty();
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public String toString() {
        return super.toString() + "(" + this.getClassKey() + ")";
    }

    public String getKey() {
        return this.getClassKey();
    }

    public void makeDirty() {
        this.cache.dirtyKey(this.getKey());
    }

    public void setIdentityCache(ObjectIdentityCache<?> cache) {
        this.cache = cache;
    }
}

