/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.WorkQueueFrontier;

class DelayedWorkQueue
implements Delayed,
Serializable {
    private static final long serialVersionUID = 1L;
    public String classKey;
    public long wakeTime;
    protected transient WorkQueue workQueue;

    public DelayedWorkQueue(WorkQueue queue) {
        this.classKey = queue.getClassKey();
        this.wakeTime = queue.getWakeTime();
        this.workQueue = queue;
    }

    public WorkQueue getWorkQueue(WorkQueueFrontier wqf) {
        if (this.workQueue == null) {
            WorkQueue result;
            this.workQueue = result = wqf.getQueueFor(this.classKey);
        }
        return this.workQueue;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.wakeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public String getClassKey() {
        return this.classKey;
    }

    public long getWakeTime() {
        return this.wakeTime;
    }

    public void setWakeTime(long time) {
        this.wakeTime = time;
    }

    @Override
    public int compareTo(Delayed obj) {
        if (this == obj) {
            return 0;
        }
        DelayedWorkQueue other = (DelayedWorkQueue)obj;
        if (this.wakeTime > other.getWakeTime()) {
            return 1;
        }
        if (this.wakeTime < other.getWakeTime()) {
            return -1;
        }
        return this.classKey.compareTo(other.getClassKey());
    }
}

