/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.modules.CrawlURI;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.springframework.beans.factory.annotation.Autowired;

public class BucketQueueAssignmentPolicy
extends QueueAssignmentPolicy {
    private static final long serialVersionUID = 3L;
    private static final int DEFAULT_NOIP_BITMASK = 1023;
    private static final int DEFAULT_QUEUES_HOSTS_MODULO = 1021;
    protected ServerCache serverCache;

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    @Override
    public String getClassKey(CrawlURI curi) {
        CrawlHost host = this.serverCache.getHostFor(curi.getUURI());
        if (host == null) {
            return "NO-HOST";
        }
        if (host.getIP() == null) {
            return "NO-IP-".concat(Long.toString(Math.abs((long)host.getHostName().hashCode()) & 0x3FFL));
        }
        return Long.toString(Math.abs((long)host.getIP().hashCode()) % 1021L);
    }

    @Override
    public int maximumNumberOfKeys() {
        return 2046;
    }
}

