/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.ToeThread;
import org.archive.crawler.reporting.AlertThreadGroup;
import org.archive.util.ArchiveUtils;
import org.archive.util.Histotable;
import org.archive.util.Reporter;

public class ToePool
extends ThreadGroup
implements Reporter {
    public static int DEFAULT_TOE_PRIORITY = 4;
    protected CrawlController controller;
    protected int nextSerialNumber = 1;
    protected int targetSize = 0;

    public ToePool(AlertThreadGroup atg, CrawlController c) {
        super(atg, "ToeThreads");
        this.controller = c;
        this.setDaemon(true);
    }

    public void cleanup() {
        Thread[] toes;
        for (Thread toe : toes = this.getToes()) {
            if (toe == null) continue;
            toe.interrupt();
        }
        this.controller = null;
    }

    public int getActiveToeCount() {
        Thread[] toes = this.getToes();
        int count = 0;
        for (int i = 0; i < toes.length; ++i) {
            if (!(toes[i] instanceof ToeThread) || !((ToeThread)toes[i]).isActive()) continue;
            ++count;
        }
        return count;
    }

    public int getToeCount() {
        Thread[] toes = this.getToes();
        int count = 0;
        for (int i = 0; i < toes.length; ++i) {
            if (!(toes[i] instanceof ToeThread)) continue;
            ++count;
        }
        return count;
    }

    private Thread[] getToes() {
        Thread[] toes = new Thread[this.activeCount() + 10];
        this.enumerate(toes);
        return toes;
    }

    public void setSize(int newsize) {
        this.targetSize = newsize;
        int difference = newsize - this.getToeCount();
        if (difference > 0) {
            for (int i = 1; i <= difference; ++i) {
                this.startNewThread();
            }
        } else {
            int retainedToes = this.targetSize;
            Thread[] toes = this.getToes();
            for (int i = 0; i < toes.length; ++i) {
                if (!(toes[i] instanceof ToeThread) || --retainedToes >= 0) continue;
                ToeThread tt = (ToeThread)toes[i];
                tt.retire();
            }
        }
    }

    public void killThread(int threadNumber, boolean replace) {
        Thread[] toes = this.getToes();
        for (int i = 0; i < toes.length; ++i) {
            ToeThread toe;
            if (!(toes[i] instanceof ToeThread) || (toe = (ToeThread)toes[i]).getSerialNumber() != threadNumber) continue;
            toe.kill();
        }
        if (replace) {
            this.startNewThread();
        }
    }

    private synchronized void startNewThread() {
        ToeThread newThread = new ToeThread(this, this.nextSerialNumber++);
        newThread.setPriority(DEFAULT_TOE_PRIORITY);
        newThread.start();
    }

    public CrawlController getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportTo(PrintWriter writer) {
        Thread[] toes;
        writer.print("Toe threads report - " + ArchiveUtils.get12DigitDate() + "\n");
        writer.print(" Job being crawled: " + this.controller.getMetadata().getJobName() + "\n");
        writer.print(" Number of toe threads in pool: " + this.getToeCount() + " (" + this.getActiveToeCount() + " active)\n\n");
        Thread[] threadArray = toes = this.getToes();
        synchronized (toes) {
            for (int i = 0; i < toes.length; ++i) {
                ToeThread tt;
                if (!(toes[i] instanceof ToeThread) || (tt = (ToeThread)toes[i]) == null) continue;
                tt.reportTo(writer);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactReportTo(PrintWriter writer) {
        writer.print(this.getToeCount() + " threads (" + this.getActiveToeCount() + " active)\n");
        Thread[] toes = this.getToes();
        boolean legendWritten = false;
        Thread[] threadArray = toes;
        synchronized (toes) {
            for (int i = 0; i < toes.length; ++i) {
                ToeThread tt;
                if (!(toes[i] instanceof ToeThread) || (tt = (ToeThread)toes[i]) == null) continue;
                if (!legendWritten) {
                    writer.println(tt.shortReportLegend());
                    legendWritten = true;
                }
                tt.shortReportLineTo(writer);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public Map<String, Object> shortReportMap() {
        Histotable steps = new Histotable();
        Histotable processors = new Histotable();
        Thread[] toes = this.getToes();
        for (int i = 0; i < toes.length; ++i) {
            ToeThread tt;
            if (!(toes[i] instanceof ToeThread) || (tt = (ToeThread)toes[i]) == null) continue;
            steps.tally((Object)tt.getStep().toString());
            String currentProcessorName = tt.getCurrentProcessorName();
            if (StringUtils.isEmpty((String)currentProcessorName)) {
                currentProcessorName = "noActiveProcessor";
            }
            processors.tally((Object)currentProcessorName);
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("toeCount", this.getToeCount());
        LinkedList<String> unwound = new LinkedList<String>();
        for (Map.Entry step : steps.getSortedByCounts()) {
            unwound.add(step.getValue() + " " + step.getKey());
        }
        data.put("steps", unwound);
        unwound = new LinkedList();
        for (Map.Entry proc : processors.getSortedByCounts()) {
            unwound.add(proc.getValue() + " " + proc.getKey());
        }
        data.put("processors", unwound);
        return data;
    }

    public void shortReportLineTo(PrintWriter w) {
        Map<String, Object> map = this.shortReportMap();
        w.print(map.get("toeCount"));
        w.print(" threads: ");
        LinkedList sortedSteps = (LinkedList)map.get("steps");
        Iterator iter = sortedSteps.iterator();
        if (!iter.hasNext()) {
            return;
        }
        w.print((String)iter.next());
        if (iter.hasNext()) {
            w.print(", ");
            w.print((String)iter.next());
            if (iter.hasNext()) {
                w.print(", etc...");
            }
        }
        w.print("; ");
        LinkedList sortedProcesses = (LinkedList)map.get("processors");
        Iterator iter2 = sortedProcesses.iterator();
        if (iter2.hasNext()) {
            w.print((String)iter2.next());
            while (iter2.hasNext()) {
                w.print(", ");
                w.print((String)iter2.next());
            }
        }
    }

    public String shortReportLegend() {
        return "total: mostCommonStateTotal secondMostCommonStateTotal";
    }

    public void waitForAll() {
        try {
            while (true) {
                if (ToePool.isAllAlive(this.getToes())) {
                    return;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isAllAlive(Thread[] threads) {
        for (Thread t : threads) {
            if (t == null || t.isAlive()) continue;
            return false;
        }
        return true;
    }
}

