/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.util.logging.Logger;
import org.archive.crawler.reporting.CrawlerLoggerModule;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public abstract class Scoper
extends Processor
implements Lifecycle {
    protected DecideRule scope;
    protected Logger fileLogger = null;
    protected CrawlerLoggerModule loggerModule;
    protected boolean isRunning;

    public DecideRule getScope() {
        return this.scope;
    }

    @Autowired
    public void setScope(DecideRule scope) {
        this.scope = scope;
    }

    public boolean getLogToFile() {
        return (Boolean)this.kp.get("logToFile");
    }

    public void setLogToFile(boolean enabled) {
        this.kp.put((Object)"logToFile", (Object)enabled);
    }

    public CrawlerLoggerModule getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(CrawlerLoggerModule loggerModule) {
        this.loggerModule = loggerModule;
    }

    public Scoper() {
        this.setLogToFile(false);
        this.isRunning = false;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        if (this.getLogToFile() && this.fileLogger == null) {
            this.fileLogger = this.loggerModule.setupSimpleLog(this.getBeanName());
        }
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    protected boolean isInScope(CrawlURI caUri) {
        boolean result = false;
        DecideResult dr = this.scope.decisionFor(caUri);
        if (dr == DecideResult.ACCEPT) {
            result = true;
            if (this.fileLogger != null) {
                this.fileLogger.info("ACCEPT " + caUri);
            }
        } else {
            this.outOfScope(caUri);
        }
        return result;
    }

    protected void outOfScope(CrawlURI caUri) {
        if (this.fileLogger != null) {
            this.fileLogger.info("REJECT " + caUri);
        }
    }
}

