/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import org.archive.crawler.event.StatSnapshotEvent;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.CrawlStatus;
import org.archive.crawler.reporting.CrawlStatSnapshot;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class CrawlLimitEnforcer
implements ApplicationListener<ApplicationEvent> {
    protected long maxBytesDownload = 0L;
    protected long maxNovelBytes = 0L;
    protected long maxNovelUrls = 0L;
    protected long maxWarcNovelUrls = 0L;
    protected long maxWarcNovelBytes = 0L;
    protected long maxDocumentsDownload = 0L;
    protected long maxTimeSeconds = 0L;
    protected CrawlController controller;

    public long getMaxBytesDownload() {
        return this.maxBytesDownload;
    }

    public void setMaxBytesDownload(long maxBytesDownload) {
        this.maxBytesDownload = maxBytesDownload;
    }

    public long getMaxNovelBytes() {
        return this.maxNovelBytes;
    }

    public void setMaxNovelBytes(long maxNovelBytes) {
        this.maxNovelBytes = maxNovelBytes;
    }

    public long getMaxNovelUrls() {
        return this.maxNovelUrls;
    }

    public void setMaxNovelUrls(long maxNovelUrls) {
        this.maxNovelUrls = maxNovelUrls;
    }

    public long getMaxWarcNovelUrls() {
        return this.maxWarcNovelUrls;
    }

    public void setMaxWarcNovelUrls(long maxWarcNovelUrls) {
        this.maxWarcNovelUrls = maxWarcNovelUrls;
    }

    public long getMaxWarcNovelBytes() {
        return this.maxWarcNovelBytes;
    }

    public void setMaxWarcNovelBytes(long maxWarcNovelBytes) {
        this.maxWarcNovelBytes = maxWarcNovelBytes;
    }

    public long getMaxDocumentsDownload() {
        return this.maxDocumentsDownload;
    }

    public void setMaxDocumentsDownload(long maxDocumentsDownload) {
        this.maxDocumentsDownload = maxDocumentsDownload;
    }

    public long getMaxTimeSeconds() {
        return this.maxTimeSeconds;
    }

    public void setMaxTimeSeconds(long maxTimeSeconds) {
        this.maxTimeSeconds = maxTimeSeconds;
    }

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StatSnapshotEvent) {
            CrawlStatSnapshot snapshot = ((StatSnapshotEvent)event).getSnapshot();
            this.checkForLimitsExceeded(snapshot);
        }
    }

    protected void checkForLimitsExceeded(CrawlStatSnapshot snapshot) {
        if (this.maxBytesDownload > 0L && snapshot.bytesProcessed >= this.maxBytesDownload) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_DATA_LIMIT);
        } else if (this.maxNovelBytes > 0L && snapshot.novelBytes >= this.maxNovelBytes) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_DATA_LIMIT);
        } else if (this.maxWarcNovelBytes > 0L && snapshot.warcNovelBytes >= this.maxWarcNovelBytes) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_DATA_LIMIT);
        } else if (this.maxDocumentsDownload > 0L && snapshot.downloadedUriCount >= this.maxDocumentsDownload) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_DOCUMENT_LIMIT);
        } else if (this.maxNovelUrls > 0L && snapshot.novelUriCount >= this.maxNovelUrls) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_DOCUMENT_LIMIT);
        } else if (this.maxWarcNovelUrls > 0L && snapshot.warcNovelUriCount >= this.maxWarcNovelUrls) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_DOCUMENT_LIMIT);
        } else if (this.maxTimeSeconds > 0L && snapshot.elapsedMilliseconds >= this.maxTimeSeconds * 1000L) {
            this.controller.requestCrawlStop(CrawlStatus.FINISHED_TIME_LIMIT);
        }
    }
}

