/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.crawler.framework.CheckpointSuccessEvent;
import org.archive.crawler.framework.CheckpointValidator;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.reporting.CrawlStatSnapshot;
import org.archive.spring.ConfigPath;
import org.archive.spring.ConfigPathConfigurer;
import org.archive.spring.HasValidator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.validation.Validator;

public class CheckpointService
implements Lifecycle,
ApplicationContextAware,
HasValidator {
    private static final Logger LOGGER = Logger.getLogger(CheckpointService.class.getName());
    protected int nextCheckpointNumber = 1;
    protected Checkpoint checkpointInProgress;
    protected Checkpoint lastCheckpoint;
    protected CrawlStatSnapshot lastCheckpointSnapshot = null;
    protected Timer timer = new Timer(true);
    protected TimerTask checkpointTask = null;
    protected ConfigPath checkpointsDir = new ConfigPath("checkpoints subdirectory", "checkpoints");
    protected long checkpointIntervalMinutes = -1L;
    protected boolean forgetAllButLatest = false;
    protected Checkpoint recoveryCheckpoint;
    protected CrawlController controller;
    protected AbstractApplicationContext appCtx;
    protected boolean isRunning = false;
    protected static Validator VALIDATOR = new CheckpointValidator();

    public ConfigPath getCheckpointsDir() {
        return this.checkpointsDir;
    }

    public void setCheckpointsDir(ConfigPath checkpointsDir) {
        this.checkpointsDir = checkpointsDir;
    }

    public long getCheckpointIntervalMinutes() {
        return this.checkpointIntervalMinutes;
    }

    public void setCheckpointIntervalMinutes(long interval) {
        long oldVal = this.checkpointIntervalMinutes;
        this.checkpointIntervalMinutes = interval;
        if (this.checkpointIntervalMinutes != oldVal) {
            this.setupCheckpointTask();
        }
    }

    public boolean getForgetAllButLatest() {
        return this.forgetAllButLatest;
    }

    public void setForgetAllButLatest(boolean forgetAllButLatest) {
        boolean oldVal = this.forgetAllButLatest;
        this.forgetAllButLatest = forgetAllButLatest;
        if (this.forgetAllButLatest != oldVal) {
            this.setupCheckpointTask();
        }
    }

    @Autowired(required=false)
    public void setRecoveryCheckpoint(Checkpoint checkpoint) {
        this.recoveryCheckpoint = checkpoint;
        checkpoint.getCheckpointDir().setBase(this.getCheckpointsDir());
    }

    public Checkpoint getRecoveryCheckpoint() {
        return this.recoveryCheckpoint;
    }

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = (AbstractApplicationContext)applicationContext;
    }

    public synchronized void start() {
        if (this.isRunning) {
            return;
        }
        if (this.getRecoveryCheckpoint() != null) {
            File cpDir = this.getRecoveryCheckpoint().getCheckpointDir().getFile();
            if (!Checkpoint.hasValidStamp((File)cpDir)) {
                LOGGER.severe("checkpoint '" + cpDir.getAbsolutePath() + "' missing validity stamp file; checkpoint data may be missing or otherwise corrupt.");
            }
            this.lastCheckpoint = this.getRecoveryCheckpoint();
            String serial = this.getRecoveryCheckpoint().getShortName().substring(2);
            try {
                Number lastCheckpointNumber = Checkpoint.INDEX_FORMAT.parse(serial);
                this.nextCheckpointNumber = lastCheckpointNumber.intValue() + 1;
            }
            catch (ParseException e) {
                LOGGER.warning("failed to parse serial from " + this.lastCheckpoint.getShortName() + " - " + e);
            }
        }
        this.isRunning = true;
        this.setupCheckpointTask();
    }

    protected synchronized void setupCheckpointTask() {
        if (this.checkpointTask != null) {
            this.checkpointTask.cancel();
        }
        if (!this.isRunning) {
            return;
        }
        long periodMs = this.getCheckpointIntervalMinutes() * 60000L;
        if (periodMs <= 0L) {
            return;
        }
        this.checkpointTask = new TimerTask(){

            @Override
            public void run() {
                if (CheckpointService.this.isCheckpointing()) {
                    LOGGER.info("CheckpointTimerThread skipping checkpoint, already checkpointing: State: " + CheckpointService.this.controller.getState());
                    return;
                }
                LOGGER.info("TimerThread request checkpoint");
                CheckpointService.this.requestCrawlCheckpoint();
            }
        };
        this.timer.schedule(this.checkpointTask, periodMs, periodMs);
        LOGGER.info("Installed Checkpoint TimerTask to checkpoint every " + periodMs + " milliseconds.");
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void stop() {
        LOGGER.info("Cleaned up Checkpoint TimerThread.");
        this.timer.cancel();
        this.isRunning = false;
    }

    public int getNextCheckpointNumber() {
        return this.nextCheckpointNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String requestCrawlCheckpoint() throws IllegalStateException {
        if (!this.controller.hasStarted()) {
            LOGGER.info("crawl job has not started; ignoring");
            return null;
        }
        if (this.isCheckpointing()) {
            throw new IllegalStateException("Checkpoint already running.");
        }
        if ((this.controller.isPaused() || this.controller.getState().equals((Object)CrawlController.State.STOPPING)) && this.controller.getStatisticsTracker().getSnapshot().sameProgressAs(this.lastCheckpointSnapshot)) {
            LOGGER.info("no progress since last checkpoint; ignoring");
            System.err.println("no progress since last checkpoint; ignoring");
            return null;
        }
        long checkpointStart = System.currentTimeMillis();
        Map toCheckpoint = this.appCtx.getBeansOfType(Checkpointable.class);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("checkpointing beans " + toCheckpoint);
        }
        this.checkpointInProgress = new Checkpoint();
        try {
            this.checkpointInProgress.setForgetAllButLatest(this.getForgetAllButLatest());
            this.checkpointInProgress.generateFrom(this.getCheckpointsDir(), this.getNextCheckpointNumber());
            long startStart = System.currentTimeMillis();
            for (Checkpointable c : toCheckpoint.values()) {
                c.startCheckpoint(this.checkpointInProgress);
            }
            LOGGER.info("all startCheckpoint() completed in " + (System.currentTimeMillis() - startStart) + "ms");
            long doStart = System.currentTimeMillis();
            for (Checkpointable c : toCheckpoint.values()) {
                long doMs = System.currentTimeMillis();
                c.doCheckpoint(this.checkpointInProgress);
                long doDuration = System.currentTimeMillis() - doMs;
                LOGGER.fine("doCheckpoint() " + c + " in " + doDuration + "ms");
            }
            LOGGER.info("all doCheckpoint() completed in " + (System.currentTimeMillis() - doStart) + "ms");
            if (this.getForgetAllButLatest() && this.lastCheckpoint != null) {
                try {
                    long deleteStart = System.currentTimeMillis();
                    FileUtils.deleteDirectory((File)this.lastCheckpoint.getCheckpointDir().getFile());
                    this.lastCheckpoint = null;
                    LOGGER.info("deleted old checkpoint in " + (System.currentTimeMillis() - deleteStart) + "ms");
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "problem deleting last checkpoint directory " + this.lastCheckpoint.getCheckpointDir().getFile(), e);
                }
            }
            this.checkpointInProgress.setSuccess(true);
            this.appCtx.publishEvent((ApplicationEvent)new CheckpointSuccessEvent(this, this.checkpointInProgress));
            this.lastCheckpointSnapshot = this.controller.getStatisticsTracker().getSnapshot();
        }
        catch (Exception e) {
            this.checkpointFailed(e);
        }
        finally {
            this.checkpointInProgress.writeValidity(this.controller.getStatisticsTracker().getProgressStamp());
            long finishStart = System.currentTimeMillis();
            for (Checkpointable c : toCheckpoint.values()) {
                c.finishCheckpoint(this.checkpointInProgress);
            }
            LOGGER.info("all finishCheckpoint() completed in " + (System.currentTimeMillis() - finishStart) + "ms");
        }
        LOGGER.info("completed checkpoint " + this.checkpointInProgress.getName() + " in " + (System.currentTimeMillis() - checkpointStart) + "ms");
        ++this.nextCheckpointNumber;
        String nameToReport = this.checkpointInProgress.getSuccess() ? this.checkpointInProgress.getName() : null;
        this.lastCheckpoint = this.checkpointInProgress;
        this.checkpointInProgress = null;
        return nameToReport;
    }

    public boolean isCheckpointing() {
        return this.checkpointInProgress != null;
    }

    protected void checkpointFailed(Exception e) {
        LOGGER.log(Level.SEVERE, " Checkpoint failed", e);
    }

    protected void checkpointFailed(String message) {
        LOGGER.warning(message);
    }

    public boolean hasAvailableCheckpoints() {
        if (this.getRecoveryCheckpoint() != null || this.isRunning()) {
            return false;
        }
        return this.findAvailableCheckpointDirectories() != null && this.findAvailableCheckpointDirectories().size() > 0;
    }

    public List<File> findAvailableCheckpointDirectories() {
        File[] dirs = this.getCheckpointsDir().getFile().listFiles((FileFilter)FileFilterUtils.directoryFileFilter());
        if (dirs == null) {
            return Collections.EMPTY_LIST;
        }
        Arrays.sort(dirs, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        LinkedList<File> dirsList = new LinkedList<File>(Arrays.asList(dirs));
        Iterator iter = dirsList.iterator();
        while (iter.hasNext()) {
            File cpDir = (File)iter.next();
            if (Checkpoint.hasValidStamp((File)cpDir)) continue;
            LOGGER.warning("checkpoint '" + cpDir + "' missing validity stamp file; ignoring");
            iter.remove();
        }
        return dirsList;
    }

    public synchronized void setRecoveryCheckpointByName(String selectedCheckpoint) {
        if (this.isRunning) {
            throw new RuntimeException("may not set recovery Checkpoint after launch");
        }
        if ("latest".equalsIgnoreCase(selectedCheckpoint)) {
            List<File> cps = this.findAvailableCheckpointDirectories();
            if (cps == null || cps.size() == 0) {
                LOGGER.warning("Cannot find any checkpoints so cannot choose the latest one! Assuming we should launch a new crawl.");
                return;
            }
            File latestFile = cps.get(0);
            selectedCheckpoint = latestFile.getName();
        }
        Checkpoint recoveryCheckpoint = new Checkpoint();
        recoveryCheckpoint.getCheckpointDir().setBase(this.getCheckpointsDir());
        recoveryCheckpoint.getCheckpointDir().setPath(selectedCheckpoint);
        recoveryCheckpoint.getCheckpointDir().setConfigurer((ConfigPathConfigurer)this.appCtx.getBean(ConfigPathConfigurer.class));
        recoveryCheckpoint.afterPropertiesSet();
        this.setRecoveryCheckpoint(recoveryCheckpoint);
        Map toSetRecovery = this.appCtx.getBeansOfType(Checkpointable.class);
        for (Checkpointable c : toSetRecovery.values()) {
            c.setRecoveryCheckpoint(recoveryCheckpoint);
        }
    }

    public Validator getValidator() {
        return VALIDATOR;
    }
}

