/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.framework.BeanLookupBindings;
import org.archive.crawler.framework.Frontier;
import org.archive.modules.seeds.SeedModule;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;

public class ActionDirectory
implements ApplicationContextAware,
Lifecycle,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(ActionDirectory.class.getName());
    protected ScheduledExecutorService executor;
    protected int initialDelaySeconds = 10;
    protected int delaySeconds = 30;
    protected ConfigPath actionDir = new ConfigPath("ActionDirectory source directory", "action");
    protected ConfigPath doneDir = new ConfigPath("ActionDirectory done directory", "${launchId}/actions-done");
    protected ApplicationContext appCtx;
    protected SeedModule seeds;
    protected Frontier frontier;
    protected static ScriptEngineManager MANAGER = new ScriptEngineManager();

    public int getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public void setInitialDelaySeconds(int initialDelay) {
        this.initialDelaySeconds = initialDelay;
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setDelaySeconds(int delay) {
        this.delaySeconds = delay;
    }

    public ConfigPath getActionDir() {
        return this.actionDir;
    }

    public void setActionDir(ConfigPath actionDir) {
        this.actionDir = actionDir;
    }

    public ConfigPath getDoneDir() {
        return this.doneDir;
    }

    public void setDoneDir(ConfigPath doneDir) {
        this.doneDir = doneDir;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    public SeedModule getSeeds() {
        return this.seeds;
    }

    @Autowired
    public void setSeeds(SeedModule seeds) {
        this.seeds = seeds;
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    @Autowired
    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    public boolean isRunning() {
        return this.executor != null && !this.executor.isShutdown();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            org.archive.util.FileUtils.ensureWriteableDirectory((File)this.getActionDir().getFile());
            org.archive.util.FileUtils.ensureWriteableDirectory((File)this.getDoneDir().getFile());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(this, this.getInitialDelaySeconds(), this.getDelaySeconds(), TimeUnit.SECONDS);
    }

    public void stop() {
        this.executor.shutdown();
        try {
            while (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.scanActionDirectory();
    }

    protected void scanActionDirectory() {
        File dir = this.actionDir.getFile();
        Object[] files = dir.listFiles((FileFilter)FileFilterUtils.fileFileFilter());
        Arrays.sort(files);
        for (Object f : files) {
            try {
                this.actOn((File)f);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "unhandled exception from actifile: " + f, e);
            }
        }
    }

    protected void actOn(File actionFile) {
        LOGGER.info("processing action file: " + actionFile);
        String filename = actionFile.getName();
        boolean isGzip = filename.endsWith(".gz");
        String corename = isGzip ? filename.substring(0, filename.length() - 3) : filename;
        String timestamp = ArchiveUtils.get17DigitDate();
        if (corename.endsWith(".seeds")) {
            this.getSeeds().actOn(actionFile);
        } else if (corename.endsWith(".recover")) {
            boolean alsoScope = corename.endsWith(".s.recover");
            try {
                this.getFrontier().importRecoverFormat(actionFile, alsoScope, true, false, "F[si] ");
                this.getFrontier().importRecoverFormat(actionFile, alsoScope, false, false, "F\\+ ");
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "problem with action file: " + actionFile, ioe);
            }
        } else if (corename.endsWith(".include")) {
            boolean alsoScope = corename.endsWith(".s.include");
            try {
                this.getFrontier().importRecoverFormat(actionFile, alsoScope, true, false, ".*");
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "problem with action file: " + actionFile, ioe);
            }
        } else if (corename.endsWith(".schedule")) {
            boolean alsoScope = corename.endsWith(".s.schedule");
            try {
                this.getFrontier().importRecoverFormat(actionFile, alsoScope, false, false, ".*");
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "problem with action file: " + actionFile, ioe);
            }
        } else if (corename.endsWith(".force")) {
            boolean alsoScope = corename.endsWith(".s.force");
            try {
                this.getFrontier().importRecoverFormat(actionFile, alsoScope, false, true, ".*");
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "problem with action file: " + actionFile, ioe);
            }
        } else if (!this.tryAsScript(actionFile, timestamp)) {
            LOGGER.warning("action file ignored: " + actionFile);
        }
        while (actionFile.exists()) {
            try {
                File doneFile = new File(this.doneDir.getFile(), timestamp + "." + actionFile.getName());
                FileUtils.moveFile((File)actionFile, (File)doneFile);
                File actionDoneDirFile = new File(this.actionDir.getFile(), "done");
                if (actionDoneDirFile.equals(this.doneDir.getFile())) continue;
                actionDoneDirFile.mkdirs();
                File doneSymlinkFile = new File(actionDoneDirFile, doneFile.getName());
                try {
                    Files.createSymbolicLink(doneSymlinkFile.toPath(), doneFile.toPath(), new FileAttribute[0]);
                }
                catch (IOException | UnsupportedOperationException e) {
                    LOGGER.log(Level.WARNING, "failed to create symlink from " + doneSymlinkFile + " to " + doneFile, e);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "unable to move " + actionFile, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryAsScript(File actionFile, String timestamp) {
        int i = actionFile.getName().lastIndexOf(".");
        if (i < 0) {
            return false;
        }
        String extension = actionFile.getName().substring(i + 1);
        ScriptEngine engine = MANAGER.getEngineByExtension(extension);
        if (engine == null) {
            return false;
        }
        StringWriter rawString = new StringWriter();
        PrintWriter rawOut = new PrintWriter(rawString);
        Exception ex = null;
        BeanLookupBindings bindings = new BeanLookupBindings(this.appCtx);
        bindings.put("rawOut", (Object)rawOut);
        bindings.put("appCtx", (Object)this.appCtx);
        try {
            String script = FileUtils.readFileToString((File)actionFile);
            engine.eval(script, (Bindings)bindings);
        }
        catch (IOException e) {
            ex = e;
        }
        catch (ScriptException e) {
            ex = e;
        }
        catch (RuntimeException e) {
            ex = e;
        }
        finally {
            bindings.put("rawOut", (Object)null);
            bindings.put("appCtx", (Object)null);
        }
        rawOut.flush();
        String allOut = rawString.toString();
        if (StringUtils.isNotBlank((String)allOut)) {
            File outFile = new File(this.doneDir.getFile(), timestamp + "." + actionFile.getName() + ".out");
            try {
                FileUtils.writeStringToFile((File)outFile, (String)rawString.toString());
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "problem during action file: " + actionFile, ioe);
            }
        }
        if (ex != null) {
            File exFile = new File(this.doneDir.getFile(), timestamp + "." + actionFile.getName() + ".exception");
            try {
                FileUtils.writeStringToFile((File)exFile, (String)ex.toString());
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "problem during action file: " + actionFile, ioe);
            }
        }
        return true;
    }
}

