/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.framework.CrawlJob;
import org.archive.crawler.framework.Engine;
import org.archive.crawler.restlet.EngineApplication;
import org.archive.crawler.restlet.RateLimitGuard;
import org.archive.util.ArchiveUtils;
import org.archive.util.KeyTool;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.security.LocalVerifier;
import org.restlet.security.MapVerifier;

public class Heritrix {
    private static final String ADHOC_PASSWORD = "password";
    private static final String ADHOC_KEYSTORE = "adhoc.keystore";
    private static final Logger logger = Logger.getLogger(Heritrix.class.getName());
    private static final String CONF = "conf";
    private static final String PROPERTIES = "logging.properties";
    protected Engine engine;
    protected Component component;
    private static final String STARTLOG = "heritrix_dmesg.log";

    private static void usage(PrintStream out, String[] args) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("Heritrix", Heritrix.options());
        out.println("Your arguments were: " + StringUtils.join((Object[])args, (char)' '));
    }

    private static Options options() {
        Options options = new Options();
        options.addOption("h", "help", true, "Usage information.");
        options.addOption("a", "web-admin", true, "REQUIRED. Specifies the authorization username and password which must be supplied to access the web interface. This may be of the form \"password\" (which leaves username as the default 'admin'), \"username:password\", or \"@filename\" for a file that includes the single line \"username:password\". ");
        options.addOption("j", "jobs-dir", true, "The jobs directory.  Defaults to ./jobs");
        options.addOption("l", "logging-properties", true, "The full path to the logging properties file (eg, conf/logging.properties).  If present, this file will be used to configure Java logging.  Defaults to ${heritrix.home}/conf/logging.properties or if no heritrix.home property set, ./conf/logging.properties");
        options.addOption("b", "web-bind-hosts", true, "A comma-separated list of addresses/hostnames for the web interface to bind to.");
        options.addOption("p", "web-port", true, "The port the web interface should listen on.");
        options.addOption("r", "run-job", true, "Run a single job and then exit when it finishes.");
        options.addOption("s", "ssl-params", true, "Specify a keystore path, keystore password, and key password for HTTPS use. Separate with commas, no whitespace.");
        options.addOption(null, "proxy-host", true, "Global http(s) proxy host to use for crawling.");
        options.addOption(null, "proxy-port", true, "Global http(s) proxy port to use for crawling.");
        return options;
    }

    private static File getDefaultPropertiesFile() {
        File confDir = new File(Heritrix.getHeritrixHome(), CONF);
        File props = new File(confDir, PROPERTIES);
        return props;
    }

    private static CommandLine getCommandLine(PrintStream out, String[] args) {
        CommandLine cl;
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(Heritrix.options(), args);
        }
        catch (ParseException e) {
            Heritrix.usage(out, args);
            return null;
        }
        if (cl.getArgList().size() != 0) {
            Heritrix.usage(out, args);
            return null;
        }
        return cl;
    }

    public static void main(String[] args) throws Exception {
        new Heritrix().instanceMain(args);
    }

    public void instanceMain(String[] args) throws Exception {
        String keyPassword;
        String keystorePassword;
        String keystorePath;
        BufferedOutputStream startupOutStream;
        PrintStream startupOut;
        CommandLine cl;
        String maxFormSize;
        System.out.println(System.getProperty("java.vendor") + ' ' + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version"));
        String ignoredSchemes = "org.archive.net.UURIFactory.ignored-schemes";
        if (System.getProperty(ignoredSchemes) == null) {
            System.setProperty(ignoredSchemes, "mailto, clsid, res, file, rtsp, about");
        }
        if (System.getProperty(maxFormSize = "org.eclipse.jetty.server.Request.maxFormContentSize") == null) {
            System.setProperty(maxFormSize, "52428800");
        }
        if ((cl = Heritrix.getCommandLine(startupOut = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)(startupOutStream = new BufferedOutputStream(new FileOutputStream(new File(Heritrix.getHeritrixHome(), STARTLOG)), 16384)))), args)) == null) {
            return;
        }
        if (cl.hasOption('h')) {
            Heritrix.usage(startupOut, args);
            return;
        }
        int port = 8443;
        HashSet bindHosts = new HashSet();
        String authLogin = "admin";
        String authPassword = null;
        File properties = Heritrix.getDefaultPropertiesFile();
        String aOption = cl.getOptionValue('a');
        if (cl.hasOption('a')) {
            String usernameColonPassword = aOption;
            try {
                int colonIndex;
                if (aOption.startsWith("@")) {
                    usernameColonPassword = FileUtils.readFileToString((File)new File(aOption.substring(1))).trim();
                }
                if ((colonIndex = usernameColonPassword.indexOf(58)) > -1) {
                    authLogin = usernameColonPassword.substring(0, colonIndex);
                    authPassword = usernameColonPassword.substring(colonIndex + 1);
                } else {
                    authPassword = usernameColonPassword;
                }
            }
            catch (IOException e) {
                System.err.println("Unable to read [username:]password from " + aOption);
            }
        }
        if (authPassword == null) {
            System.err.println("You must specify a valid [username:]password for the web interface using -a.");
            System.exit(1);
            authPassword = "";
        }
        File jobsDir = null;
        jobsDir = cl.hasOption('j') ? new File(cl.getOptionValue('j')) : new File("./jobs");
        if (cl.hasOption('l')) {
            properties = new File(cl.getOptionValue('l'));
        }
        if (cl.hasOption('b')) {
            String hosts = cl.getOptionValue('b');
            List<Object> list = "/".equals(hosts) ? new ArrayList() : Arrays.asList(hosts.split(","));
            bindHosts.addAll(list);
        } else {
            bindHosts.add("localhost");
        }
        if (cl.hasOption('p')) {
            port = Integer.parseInt(cl.getOptionValue('p'));
        }
        if (cl.hasOption('s')) {
            String[] sslParams = cl.getOptionValue('s').split(",");
            keystorePath = sslParams[0];
            keystorePassword = sslParams[1];
            keyPassword = sslParams[2];
        } else {
            keystorePath = ADHOC_KEYSTORE;
            keystorePassword = ADHOC_PASSWORD;
            keyPassword = ADHOC_PASSWORD;
            this.useAdhocKeystore(startupOut);
        }
        if (cl.hasOption("proxy-host")) {
            String proxyHost = cl.getOptionValue("proxy-host");
            String proxyPort = cl.getOptionValue("proxy-port", "8000");
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
            System.setProperty("https.proxyHost", proxyHost);
            System.setProperty("https.proxyPort", proxyPort);
        }
        System.setProperty("java.util.logging.config.file", properties.getPath());
        if (properties.exists()) {
            FileInputStream finp = new FileInputStream(properties);
            LogManager.getLogManager().readConfiguration(finp);
            finp.close();
        }
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        this.setupGlobalProperties(port);
        try {
            this.engine = new Engine(jobsDir);
            this.component = new Component();
            if (bindHosts.isEmpty()) {
                this.setupServer(this.component, port, null, keystorePath, keystorePassword, keyPassword);
            } else {
                for (String address : bindHosts) {
                    this.setupServer(this.component, port, address, keystorePath, keystorePassword, keyPassword);
                }
            }
            this.component.getClients().add(Protocol.FILE);
            this.component.getClients().add(Protocol.CLAP);
            MapVerifier verifier = new MapVerifier();
            verifier.getLocalSecrets().put(authLogin, authPassword.toCharArray());
            RateLimitGuard guard = new RateLimitGuard(this.component.getContext().createChildContext(), "Authentication Required", UUID.randomUUID().toString());
            guard.setWrappedVerifier((LocalVerifier)verifier);
            guard.setNext((Restlet)new EngineApplication(this.engine));
            this.component.getDefaultHost().attach((Restlet)guard);
            this.component.start();
            startupOut.println("engine listening at port " + port);
            startupOut.println("operator login set per " + (aOption.startsWith("@") ? "file " + aOption : "command-line"));
            if (authPassword.length() < 8 || authPassword.matches("[a-zA-Z]{0,10}") || authPassword.matches("\\d{0,10}")) {
                startupOut.println("NOTE: We recommend a longer, stronger password, especially if your web \ninterface will be internet-accessible.");
            }
            if (cl.hasOption('r')) {
                String jobName = cl.getOptionValue('r');
                this.engine.requestLaunch(jobName);
                CrawlJob job = this.engine.getJob(jobName);
                if (job == null || job.getCrawlController() == null) {
                    System.err.println("Failed to launch job: " + jobName);
                    System.exit(1);
                }
                job.getCrawlController().requestCrawlResume();
                this.engine.waitForNoRunningJobs(0L);
                this.engine.shutdown();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace(startupOut);
            if (this.component != null) {
                this.component.stop();
            }
            throw e;
        }
        finally {
            startupOut.flush();
            startupOutStream.close();
            System.out.println("Heritrix version: " + ArchiveUtils.VERSION);
        }
    }

    protected void setupGlobalProperties(int port) {
        if (System.getProperty("heritrix.port") == null) {
            System.setProperty("heritrix.port", port + "");
        }
        String hostname = "localhost.localdomain";
        if (System.getProperty("heritrix.hostname") == null) {
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ue) {
                logger.warning("Failed getHostAddress for this host: " + ue);
            }
            System.setProperty("heritrix.hostname", hostname);
        }
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        if (System.getProperty("heritrix.runtimeName") == null) {
            System.setProperty("heritrix.runtimeName", runtimeName);
        }
        if (System.getProperty("heritrix.pid") == null && runtimeName.matches("\\d+@\\S+")) {
            System.setProperty("heritrix.pid", runtimeName.substring(0, runtimeName.indexOf("@")));
        }
    }

    protected void useAdhocKeystore(PrintStream startupOut) {
        try {
            File keystoreFile = new File(ADHOC_KEYSTORE);
            if (!keystoreFile.exists()) {
                String[] args = new String[]{"-keystore", ADHOC_KEYSTORE, "-storepass", ADHOC_PASSWORD, "-keypass", ADHOC_PASSWORD, "-alias", "adhoc", "-genkey", "-keyalg", "RSA", "-dname", "CN=Heritrix Ad-Hoc HTTPS Certificate", "-validity", "3650"};
                KeyTool.main((String[])args);
            }
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            ByteArrayInputStream inStream = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)keystoreFile));
            keystore.load(inStream, ADHOC_PASSWORD.toCharArray());
            Certificate cert = keystore.getCertificate("adhoc");
            byte[] certBytes = cert.getEncoded();
            byte[] sha1 = MessageDigest.getInstance("SHA1").digest(certBytes);
            startupOut.print("Using ad-hoc HTTPS certificate with fingerprint...\nSHA1");
            for (byte b : sha1) {
                startupOut.print(String.format(":%02X", b));
            }
            startupOut.println("\nVerify in browser before accepting exception.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setupServer(Component component, int port, String address, String keystorePath, String keystorePassword, String keyPassword) {
        Server server = component.getServers().add(Protocol.HTTPS, address, port);
        server.getContext().getParameters().add("keystorePath", keystorePath);
        server.getContext().getParameters().add("keystorePassword", keystorePassword);
        server.getContext().getParameters().add("keyPassword", keyPassword);
    }

    protected static File getHeritrixHome() {
        String home = System.getProperty("heritrix.home");
        if (home != null && home.length() > 0) {
            File candidate = new File(home);
            if (candidate.exists()) {
                return candidate;
            }
            logger.warning("HERITRIX_HOME <" + home + "> does not exist; using current working directory instead.");
        }
        return new File(System.getProperty("user.dir"));
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Component getComponent() {
        return this.component;
    }
}

