/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import javax.servlet.http.HttpServletRequest;
import org.appfuse.model.User;
import org.appfuse.webapp.action.BasePage;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.mail.MailException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class PasswordHint
extends BasePage {
    private String username;

    public void setUsername(String username) {
        this.username = username;
    }

    public String execute() {
        this.getFacesContext().getViewRoot().setViewId("/passwordHint.xhtml");
        if (this.username == null || "".equals(this.username)) {
            this.log.warn((Object)"Username not specified, notifying user that it's a required field.");
            this.addError("errors.required", (Object)this.getText("user.username"));
            return null;
        }
        if (this.username.endsWith(".xhtml")) {
            this.username = this.username.substring(0, this.username.indexOf(".xhtml"));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Processing Password Hint...");
        }
        try {
            User user = this.userManager.getUserByUsername(this.username);
            StringBuilder msg = new StringBuilder();
            msg.append("Your password hint is: ").append(user.getPasswordHint());
            msg.append("\n\nLogin at: ").append(RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
            this.message.setTo(user.getEmail());
            String subject = '[' + this.getText("webapp.name") + "] " + this.getText("user.passwordHint");
            this.message.setSubject(subject);
            this.message.setText(msg.toString());
            this.mailEngine.send(this.message);
            this.addMessage("login.passwordHint.sent", (Object)new Object[]{this.username, user.getEmail()});
        }
        catch (UsernameNotFoundException e) {
            this.log.warn((Object)e.getMessage());
            this.addError("login.passwordHint.error", (Object)this.username);
        }
        catch (MailException me) {
            this.addError(me.getCause().getLocalizedMessage());
        }
        return "success";
    }
}

