/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.MailEngine;
import org.appfuse.service.UserManager;
import org.appfuse.webapp.action.CountryModel;
import org.springframework.mail.SimpleMailMessage;

public class BasePage {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected UserManager userManager;
    protected MailEngine mailEngine;
    protected SimpleMailMessage message;
    protected String templateName;
    protected FacesContext facesContext;
    protected String sortColumn;
    protected boolean ascending = true;
    protected boolean nullsAreHigh;

    public FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public String getParameter(String name) {
        return this.getRequest().getParameter(name);
    }

    public Map getCountries() {
        CountryModel model = new CountryModel();
        return model.getCountries(this.getRequest().getLocale());
    }

    public String getBundleName() {
        return this.getFacesContext().getApplication().getMessageBundle();
    }

    public ResourceBundle getBundle() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourceBundle.getBundle(this.getBundleName(), this.getRequest().getLocale(), classLoader);
    }

    public String getText(String key) {
        String message;
        try {
            message = this.getBundle().getString(key);
        }
        catch (MissingResourceException mre) {
            this.log.warn((Object)("Missing key for '" + key + "'"));
            return "???" + key + "???";
        }
        return message;
    }

    public String getText(String key, Object arg) {
        if (arg == null) {
            return this.getText(key);
        }
        MessageFormat form = new MessageFormat(this.getBundle().getString(key));
        if (arg instanceof String) {
            return form.format(new Object[]{arg});
        }
        if (arg instanceof Object[]) {
            return form.format(arg);
        }
        this.log.error((Object)("arg '" + arg + "' not String or Object[]"));
        return "";
    }

    protected void addMessage(String key, Object arg) {
        ArrayList<String> messages = (ArrayList<String>)this.getSession().getAttribute("messages");
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(this.getText(key, arg));
        this.getSession().setAttribute("messages", messages);
    }

    protected void addMessage(String key) {
        this.addMessage(key, null);
    }

    protected void addError(String key, Object arg) {
        ArrayList<String> errors = (ArrayList<String>)this.getSession().getAttribute("errors");
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        if (key.contains(" ") && arg == null) {
            errors.add(key);
        } else {
            errors.add(this.getText(key, arg));
        }
        this.getSession().setAttribute("errors", errors);
    }

    protected void addError(String key) {
        this.addError(key, null);
    }

    public boolean hasErrors() {
        return this.getSession().getAttribute("errors") != null;
    }

    protected HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getFacesContext().getExternalContext().getRequest();
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession();
    }

    protected HttpServletResponse getResponse() {
        return (HttpServletResponse)this.getFacesContext().getExternalContext().getResponse();
    }

    protected ServletContext getServletContext() {
        return (ServletContext)this.getFacesContext().getExternalContext().getContext();
    }

    protected Map getConfiguration() {
        HashMap config = (HashMap)this.getServletContext().getAttribute("appConfig");
        if (config == null) {
            return new HashMap();
        }
        return config;
    }

    protected void sendUserMessage(User user, String msg, String url) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sending e-mail to user [" + user.getEmail() + "]..."));
        }
        this.message.setTo(user.getFullName() + "<" + user.getEmail() + ">");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("message", msg);
        model.put("applicationURL", url);
        this.mailEngine.sendMessage(this.message, this.templateName, model);
    }

    public void setMailEngine(MailEngine mailEngine) {
        this.mailEngine = mailEngine;
    }

    public void setMessage(SimpleMailMessage message) {
        this.message = message;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    protected List sort(List list) {
        BeanComparator comparator = new BeanComparator(this.sortColumn, (Comparator)new NullComparator(this.nullsAreHigh));
        if (!this.ascending) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(list, comparator);
        return list;
    }
}

