/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest.backoff;

import io.searchbox.action.AbstractAction;
import io.searchbox.client.JestResult;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.appenders.log4j2.elasticsearch.backoff.BatchLimitBackoffPolicy;

@Plugin(name="BatchLimitBackoffPolicy", category="Core", elementType="BackoffPolicy", printObject=true)
public class Log4j2BatchLimitBackoffPolicy
extends BatchLimitBackoffPolicy<AbstractAction<JestResult>> {
    static final String PLUGIN_NAME = "BatchLimitBackoffPolicy";

    public Log4j2BatchLimitBackoffPolicy(int maxBatchesInFlight) {
        super(maxBatchesInFlight);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<BatchLimitBackoffPolicy> {
        static final int DEFAULT_MAX_BATCHES_IN_FLIGHT = 8;
        @PluginBuilderAttribute(value="maxBatchesInFlight")
        protected int maxBatchesInFlight = 8;

        public final BatchLimitBackoffPolicy build() {
            if (this.maxBatchesInFlight <= 0) {
                throw new ConfigurationException("maxBatchesInFlight must be higher than 0 for " + BatchLimitBackoffPolicy.class.getSimpleName());
            }
            return new Log4j2BatchLimitBackoffPolicy(this.maxBatchesInFlight);
        }

        public Builder withMaxBatchesInFlight(int maxBatchesInFlight) {
            this.maxBatchesInFlight = maxBatchesInFlight;
            return this;
        }
    }
}

