/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class PutComponentTemplate
extends SetupStep<GenericJestRequest, JestResult> {
    protected final String templateName;
    protected final String source;

    public PutComponentTemplate(String templateName, String source) {
        this.templateName = templateName;
        this.source = source;
    }

    public Result onResponse(JestResult response) {
        if (response.isSucceeded()) {
            InternalLogging.getLogger().info("{}: Component template {} updated", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.templateName});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to update component template: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        return new GenericJestRequest("PUT", this.source){

            @Override
            public String buildURI() {
                return "_component_template/" + PutComponentTemplate.this.templateName;
            }
        };
    }
}

