/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractDocumentTargetedAction;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import io.searchbox.core.JestBatchIntrospector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Auth;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.ClientProvider;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.backoff.BackoffPolicy;
import org.appenders.log4j2.elasticsearch.backoff.NoopBackoffPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemOps;
import org.appenders.log4j2.elasticsearch.jest.ExtendedJestClientFactory;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;
import org.appenders.log4j2.elasticsearch.jest.JestBulkOperations;
import org.appenders.log4j2.elasticsearch.jest.JestOperationFactoryDispatcher;
import org.appenders.log4j2.elasticsearch.jest.WrappedHttpClientConfig;
import org.appenders.log4j2.elasticsearch.jest.failover.JestHttpFailedItemOps;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.Metric;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfigFactory;
import org.appenders.log4j2.elasticsearch.metrics.Metrics;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;
import org.appenders.log4j2.elasticsearch.util.SplitUtil;

@Plugin(name="JestHttp", category="Core", elementType="objectFactory", printObject=true)
public class JestHttpObjectFactory
implements ClientObjectFactory<JestClient, Bulk>,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final Collection<String> serverUris;
    private final int connTimeout;
    private final int readTimeout;
    private final int maxTotalConnections;
    private final int defaultMaxTotalConnectionsPerRoute;
    private final int ioThreadCount;
    private final boolean discoveryEnabled;
    private final Auth<HttpClientConfig.Builder> auth;
    protected final String mappingType;
    protected final boolean dataStreamsEnabled;
    protected final FailedItemOps<AbstractDocumentTargetedAction<DocumentResult>> failedItemOps;
    protected final BackoffPolicy<AbstractAction<BulkResult>> backoffPolicy;
    private final ConcurrentLinkedQueue<Operation> operations = new ConcurrentLinkedQueue();
    private final ValueResolver valueResolver;
    private OperationFactory setupOps;
    private JestClient client;
    protected final JestBatchIntrospector introspector = new JestBatchIntrospector();
    protected final BatchingClientMetrics metrics;

    protected JestHttpObjectFactory(Builder builder) {
        this.serverUris = SplitUtil.split((String)builder.serverUris, (String)";");
        this.connTimeout = builder.connTimeout;
        this.readTimeout = builder.readTimeout;
        this.maxTotalConnections = builder.maxTotalConnection;
        this.defaultMaxTotalConnectionsPerRoute = builder.defaultMaxTotalConnectionPerRoute;
        this.ioThreadCount = builder.ioThreadCount;
        this.discoveryEnabled = builder.discoveryEnabled;
        this.auth = builder.auth;
        this.mappingType = builder.mappingType;
        this.dataStreamsEnabled = builder.dataStreamsEnabled;
        this.failedItemOps = builder.failedItemOps;
        this.backoffPolicy = builder.backoffPolicy;
        this.valueResolver = builder.valueResolver;
        this.metrics = new BatchingClientMetrics(builder.name, builder.metricsFactory);
    }

    public static List<MetricConfig> metricConfigs(boolean enabled) {
        return BatchingClientMetrics.createConfigs(enabled);
    }

    public Collection<String> getServerList() {
        return new ArrayList<String>(this.serverUris);
    }

    public JestClient createClient() {
        if (this.client == null) {
            HttpClientConfig.Builder builder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(this.serverUris).maxTotalConnection(this.maxTotalConnections).defaultMaxTotalConnectionPerRoute(this.defaultMaxTotalConnectionsPerRoute).connTimeout(this.connTimeout)).readTimeout(this.readTimeout)).discoveryEnabled(this.discoveryEnabled)).multiThreaded(true);
            if (this.auth != null) {
                this.auth.configure((Object)builder);
            }
            WrappedHttpClientConfig.Builder wrappedHttpClientConfigBuilder = new WrappedHttpClientConfig.Builder(builder.build()).ioThreadCount(this.ioThreadCount);
            this.client = (JestClient)this.getClientProvider(wrappedHttpClientConfigBuilder).createClient();
        }
        return this.client;
    }

    public Function<Bulk, Boolean> createBatchListener(final FailoverPolicy failoverPolicy) {
        return new Function<Bulk, Boolean>(){
            private final Function<Bulk, Boolean> failureHandler;
            {
                this.failureHandler = JestHttpObjectFactory.this.createFailureHandler(failoverPolicy);
            }

            @Override
            public Boolean apply(Bulk bulk) {
                JestHttpObjectFactory.this.executePreBatchOperations();
                if (JestHttpObjectFactory.this.backoffPolicy.shouldApply((Object)bulk)) {
                    JestHttpObjectFactory.this.metrics.backoffApplied(1);
                    InternalLogging.getLogger().warn("Backoff applied. Batch rejected", new Object[0]);
                    this.failureHandler.apply(bulk);
                    return false;
                }
                JestHttpObjectFactory.this.backoffPolicy.register((Object)bulk);
                JestHttpObjectFactory.this.metrics.itemsSent(JestHttpObjectFactory.this.getBatchSize(bulk));
                JestResultHandler<JestResult> jestResultHandler = JestHttpObjectFactory.this.createResultHandler(bulk, this.failureHandler);
                JestHttpObjectFactory.this.createClient().executeAsync((Action)bulk, jestResultHandler);
                return true;
            }
        };
    }

    int getBatchSize(Bulk bulk) {
        return this.introspector.items(bulk).size();
    }

    int executePreBatchOperations() {
        int executionCount = 0;
        while (!this.operations.isEmpty()) {
            try {
                ((Operation)this.operations.remove()).execute();
            }
            catch (Exception e) {
                InternalLogging.getLogger().error("Deferred operation failed: {}", new Object[]{e.getMessage()});
            }
            finally {
                ++executionCount;
            }
        }
        return executionCount;
    }

    public Function<Bulk, Boolean> createFailureHandler(FailoverPolicy failover) {
        return bulk -> {
            long start = System.currentTimeMillis();
            Collection items = this.introspector.items((Bulk)bulk);
            this.metrics.batchFailed();
            this.metrics.itemsFailed(items.size());
            InternalLogging.getLogger().warn(String.format("Batch of %s items failed. Redirecting to %s", items.size(), failover.getClass().getName()), new Object[0]);
            items.forEach(item -> {
                Index failedAction = (Index)item;
                failover.deliver(this.failedItemOps.createItem((Object)failedAction));
            });
            this.metrics.failoverTookMs(System.currentTimeMillis() - start);
            return true;
        };
    }

    public BatchOperations<Bulk> createBatchOperations() {
        if (this.dataStreamsEnabled) {
            return new JestBulkOperations(true);
        }
        return new JestBulkOperations(this.mappingType);
    }

    private Result executeOperation(SetupStep<GenericJestRequest, JestResult> operation) {
        try {
            JestResult result = this.createClient().execute((Action)operation.createRequest());
            return operation.onResponse((Object)result);
        }
        catch (IOException e) {
            return operation.onException((Exception)e);
        }
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public OperationFactory setupOperationFactory() {
        if (this.setupOps == null) {
            this.setupOps = new JestOperationFactoryDispatcher((StepProcessor<SetupStep<GenericJestRequest, JestResult>>)((StepProcessor)this::executeOperation), this.valueResolver);
        }
        return this.setupOps;
    }

    protected JestResultHandler<JestResult> createResultHandler(final Bulk bulk, final Function<Bulk, Boolean> failureHandler) {
        return new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                JestHttpObjectFactory.this.backoffPolicy.deregister((Object)bulk);
                if (!result.isSucceeded()) {
                    InternalLogging.getLogger().warn(result.getErrorMessage(), new Object[0]);
                    failureHandler.apply(bulk);
                } else {
                    JestHttpObjectFactory.this.metrics.itemsDelivered(JestHttpObjectFactory.this.getBatchSize(bulk));
                }
            }

            public void failed(Exception ex) {
                InternalLogging.getLogger().warn(ex.getMessage(), new Object[]{ex});
                JestHttpObjectFactory.this.backoffPolicy.deregister((Object)bulk);
                failureHandler.apply(bulk);
            }
        };
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    ValueResolver valueResolver() {
        return this.valueResolver;
    }

    ClientProvider<JestClient> getClientProvider(WrappedHttpClientConfig.Builder clientConfigBuilder) {
        return new JestClientProvider(clientConfigBuilder);
    }

    public void register(MetricsRegistry registry) {
        this.metrics.register(registry);
    }

    public void deregister() {
        this.metrics.deregister();
    }

    public void start() {
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        InternalLogging.getLogger().debug("Stopping {}", new Object[]{this.getClass().getSimpleName()});
        if (this.client != null) {
            this.client.shutdownClient();
        }
        this.state = LifeCycle.State.STOPPED;
        InternalLogging.getLogger().debug("{} stopped", new Object[]{this.getClass().getSimpleName()});
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public static class BatchingClientMetrics
    implements Metrics {
        private final List<MetricsRegistry.Registration> registrations = new ArrayList<MetricsRegistry.Registration>();
        private final Metric itemsSent;
        private final Metric itemsDelivered;
        private final Metric itemsFailed;
        private final Metric backoffApplied;
        private final Metric batchesFailed;
        private final Metric failoverTookMs;

        public BatchingClientMetrics(String name, MetricsFactory factory) {
            this.itemsSent = factory.createMetric(name, "itemsSent");
            this.itemsDelivered = factory.createMetric(name, "itemsDelivered");
            this.itemsFailed = factory.createMetric(name, "itemsFailed");
            this.backoffApplied = factory.createMetric(name, "backoffApplied");
            this.batchesFailed = factory.createMetric(name, "batchesFailed");
            this.failoverTookMs = factory.createMetric(name, "failoverTookMs");
        }

        public static List<MetricConfig> createConfigs(boolean enabled) {
            return Collections.unmodifiableList(Arrays.asList(MetricConfigFactory.createCountConfig((boolean)enabled, (String)"itemsSent"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"itemsDelivered"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"itemsFailed"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"backoffApplied"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"batchesFailed"), MetricConfigFactory.createMaxConfig((boolean)enabled, (String)"failoverTookMs", (boolean)true)));
        }

        public void register(MetricsRegistry registry) {
            this.registrations.add(registry.register(this.itemsSent));
            this.registrations.add(registry.register(this.itemsDelivered));
            this.registrations.add(registry.register(this.itemsFailed));
            this.registrations.add(registry.register(this.backoffApplied));
            this.registrations.add(registry.register(this.batchesFailed));
            this.registrations.add(registry.register(this.failoverTookMs));
        }

        public void deregister() {
            this.registrations.forEach(MetricsRegistry.Registration::deregister);
            this.registrations.clear();
        }

        public void itemsSent(int itemsSent) {
            this.itemsSent.store(itemsSent);
        }

        public void itemsDelivered(int count) {
            this.itemsDelivered.store(count);
        }

        public void itemsFailed(int count) {
            this.itemsFailed.store(count);
        }

        public void backoffApplied(int count) {
            this.backoffApplied.store(count);
        }

        public void batchFailed() {
            this.batchesFailed.store(1);
        }

        public void failoverTookMs(long tookMs) {
            this.failoverTookMs.store(tookMs);
        }
    }

    static class JestClientProvider
    implements ClientProvider<JestClient> {
        private final WrappedHttpClientConfig.Builder clientConfigBuilder;

        public JestClientProvider(WrappedHttpClientConfig.Builder clientConfigBuilder) {
            this.clientConfigBuilder = clientConfigBuilder;
        }

        public JestClient createClient() {
            ExtendedJestClientFactory jestClientFactory = new ExtendedJestClientFactory(this.clientConfigBuilder.build());
            return jestClientFactory.getObject();
        }
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<JestHttpObjectFactory> {
        private static final BackoffPolicy<AbstractAction<BulkResult>> DEFAULT_BACKOFF_POLICY = new NoopBackoffPolicy();
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required(message="No serverUris provided for JestClientConfig")
        protected String serverUris;
        @PluginBuilderAttribute
        protected int connTimeout = -1;
        @PluginBuilderAttribute
        protected int readTimeout = -1;
        @PluginBuilderAttribute
        protected int maxTotalConnection = 40;
        @PluginBuilderAttribute
        protected int defaultMaxTotalConnectionPerRoute = 4;
        @PluginBuilderAttribute
        protected int ioThreadCount = Runtime.getRuntime().availableProcessors();
        @PluginBuilderAttribute
        protected boolean discoveryEnabled;
        @PluginElement(value="auth")
        protected Auth auth;
        @PluginBuilderAttribute
        protected String name = "JestHttp";
        @PluginElement(value="metricsFactory")
        protected MetricsFactory metricsFactory = new DefaultMetricsFactory(BatchingClientMetrics.createConfigs(false));
        @PluginBuilderAttribute
        protected String mappingType = JestBulkOperations.DEFAULT_MAPPING_TYPE;
        @PluginBuilderAttribute
        protected Boolean dataStreamsEnabled = Boolean.FALSE;
        @PluginElement(value="backoffPolicy")
        protected BackoffPolicy<AbstractAction<BulkResult>> backoffPolicy = DEFAULT_BACKOFF_POLICY;
        protected FailedItemOps<AbstractDocumentTargetedAction<DocumentResult>> failedItemOps = this.failedItemOps();
        protected ValueResolver valueResolver;

        public JestHttpObjectFactory build() {
            this.validate();
            this.resolveLazyProperties();
            return new JestHttpObjectFactory(this);
        }

        protected void resolveLazyProperties() {
            this.valueResolver = this.getValueResolver();
        }

        private ValueResolver getValueResolver() {
            if (this.valueResolver != null) {
                return this.valueResolver;
            }
            if (this.configuration != null) {
                return new Log4j2Lookup(this.configuration.getStrSubstitutor());
            }
            return ValueResolver.NO_OP;
        }

        protected FailedItemOps<AbstractDocumentTargetedAction<DocumentResult>> failedItemOps() {
            return new JestHttpFailedItemOps();
        }

        protected void validate() {
            if (this.serverUris == null) {
                throw new ConfigurationException("No serverUris provided for " + JestHttpObjectFactory.class.getSimpleName());
            }
            if (this.backoffPolicy == null) {
                throw new ConfigurationException("No BackoffPolicy provided for JestHttp");
            }
        }

        public Builder withServerUris(String serverUris) {
            this.serverUris = serverUris;
            return this;
        }

        public Builder withMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
            return this;
        }

        public Builder withDefaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
            return this;
        }

        public Builder withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder withDiscoveryEnabled(boolean discoveryEnabled) {
            this.discoveryEnabled = discoveryEnabled;
            return this;
        }

        public Builder withAuth(Auth auth) {
            this.auth = auth;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMetricConfig(MetricConfig metricConfig) {
            this.metricsFactory.configure(metricConfig);
            return this;
        }

        public Builder withMetricConfigs(List<MetricConfig> metricConfigs) {
            this.metricsFactory.configure(metricConfigs);
            return this;
        }

        public Builder withMappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        public Builder withDataStreamsEnabled(boolean dataStreamsEnabled) {
            this.dataStreamsEnabled = dataStreamsEnabled;
            return this;
        }

        public Builder withBackoffPolicy(BackoffPolicy<AbstractAction<BulkResult>> backoffPolicy) {
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withValueResolver(ValueResolver valueResolver) {
            this.valueResolver = valueResolver;
            return this;
        }
    }
}

