/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.config.HttpClientConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.appenders.log4j2.elasticsearch.CertInfo;

@Plugin(name="JKS", category="Core", elementType="certInfo")
public class JKSCertInfo
implements CertInfo<HttpClientConfig.Builder> {
    static final String PLUGIN_NAME = "JKS";
    static final String configExceptionMessage = "Failed to apply SSL/TLS settings";
    private final String keystorePath;
    private final String truststorePath;
    private final String keystorePassword;
    private final String truststorePassword;

    protected JKSCertInfo(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) {
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
    }

    public void applyTo(HttpClientConfig.Builder clientConfigBuilder) {
        try (FileInputStream keystoreFile = new FileInputStream(new File(this.keystorePath));
             FileInputStream truststoreFile = new FileInputStream(new File(this.truststorePath));){
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(keystoreFile, this.keystorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keystorePassword.toCharArray());
            KeyStore trustStore = KeyStore.getInstance("jks");
            trustStore.load(truststoreFile, this.truststorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            clientConfigBuilder.sslSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
            clientConfigBuilder.httpsIOSessionStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)new NoopHostnameVerifier()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigurationException(configExceptionMessage, (Throwable)e);
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<JKSCertInfo> {
        public static final String EMPTY_PASSWORD = "";
        @PluginBuilderAttribute
        private String keystorePath;
        @PluginBuilderAttribute
        private String keystorePassword = "";
        @PluginBuilderAttribute
        private String truststorePath;
        @PluginBuilderAttribute
        private String truststorePassword = "";

        public JKSCertInfo build() {
            if (this.keystorePath == null) {
                throw new ConfigurationException("No keystorePath provided for JKS");
            }
            if (this.keystorePassword == null) {
                throw new ConfigurationException("No keystorePassword provided for JKS");
            }
            if (this.truststorePath == null) {
                throw new ConfigurationException("No truststorePath provided for JKS");
            }
            if (this.truststorePassword == null) {
                throw new ConfigurationException("No truststorePassword provided for JKS");
            }
            return new JKSCertInfo(this.keystorePath, this.keystorePassword, this.truststorePath, this.truststorePassword);
        }

        public Builder withKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder withKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder withTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        public Builder withTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }
    }
}

