/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupContext;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class CreateDataStream
extends SetupStep<GenericJestRequest, JestResult> {
    protected final String name;
    protected final String source;

    public CreateDataStream(String name, String source) {
        this.name = name;
        this.source = source;
    }

    public boolean shouldProcess(SetupContext setupContext) {
        boolean shouldExecute = Result.SUCCESS.equals((Object)setupContext.getLatestResult());
        if (!shouldExecute) {
            InternalLogging.getLogger().info("{}: Skipping data stream creation", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
        return shouldExecute;
    }

    public Result onResponse(JestResult response) {
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Data stream {} created", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to create data stream: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        return new GenericJestRequest("PUT", null){

            @Override
            public String buildURI() {
                return "_data_stream/" + CreateDataStream.this.name;
            }
        };
    }
}

