/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupContext;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class CreateBootstrapIndex
extends SetupStep<GenericJestRequest, JestResult> {
    public static final String BOOTSTRAP_TEMPLATE = "{\"aliases\": {\"%s\":{\"is_write_index\":true}}}";
    protected final String rolloverAlias;
    protected final String bootstrapIndexName;

    public CreateBootstrapIndex(String rolloverAlias) {
        this.rolloverAlias = rolloverAlias;
        this.bootstrapIndexName = String.format("%s-000001", rolloverAlias);
    }

    public boolean shouldProcess(SetupContext setupContext) {
        boolean shouldExecute = Result.SUCCESS.equals((Object)setupContext.getLatestResult());
        if (!shouldExecute) {
            InternalLogging.getLogger().info("{}: Skipping bootstrap index creation", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
        return shouldExecute;
    }

    public Result onResponse(JestResult response) {
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Bootstrap index {} created", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.bootstrapIndexName});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to create bootstrap index: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        String source = String.format(BOOTSTRAP_TEMPLATE, this.rolloverAlias);
        return new GenericJestRequest("PUT", source){

            @Override
            public String buildURI() {
                return CreateBootstrapIndex.this.bootstrapIndexName;
            }
        };
    }
}

