/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.BulkEmitter;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.jest.JestHttpObjectFactory;

public class BulkEmitterFactory
implements BatchEmitterFactory<BulkEmitter> {
    public boolean accepts(Class clientObjectFactoryClass) {
        return JestHttpObjectFactory.class.isAssignableFrom(clientObjectFactoryClass);
    }

    public int loadingOrder() {
        String priority = System.getProperty("appenders." + BulkEmitterFactory.class.getSimpleName() + ".loadingOrder");
        if (priority == null) {
            return 110;
        }
        return Integer.parseInt(priority);
    }

    public BulkEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
        BulkEmitter bulkEmitter = new BulkEmitter(batchSize, deliveryInterval, clientObjectFactory.createBatchOperations());
        bulkEmitter.addListener(clientObjectFactory.createBatchListener(failoverPolicy));
        return bulkEmitter;
    }
}

