/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.action.AbstractDocumentTargetedAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Bulk;
import io.searchbox.core.DocumentResult;
import java.util.function.Function;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ClientProvider;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.GenericItemSourcePool;
import org.appenders.log4j2.elasticsearch.JacksonMixIn;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.failover.FailedItemOps;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulk;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulkOperations;
import org.appenders.log4j2.elasticsearch.jest.BufferedIndex;
import org.appenders.log4j2.elasticsearch.jest.BufferedJestClientFactory;
import org.appenders.log4j2.elasticsearch.jest.JestHttpObjectFactory;
import org.appenders.log4j2.elasticsearch.jest.WrappedHttpClientConfig;
import org.appenders.log4j2.elasticsearch.jest.failover.BufferedHttpFailedItemOps;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

@Plugin(name="JestBufferedHttp", category="Core", elementType="objectFactory", printObject=true)
public class BufferedJestHttpObjectFactory
extends JestHttpObjectFactory {
    public static final String PLUGIN_NAME = "JestBufferedHttp";
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final PooledItemSourceFactory itemSourceFactory;
    private final JacksonMixIn[] mixIns;

    protected BufferedJestHttpObjectFactory(Builder builder) {
        super(builder);
        this.itemSourceFactory = builder.pooledItemSourceFactory;
        this.mixIns = builder.mixIns;
    }

    @Override
    public Function<Bulk, Boolean> createFailureHandler(FailoverPolicy failover) {
        return bulk -> {
            long start = System.currentTimeMillis();
            BufferedBulk bufferedBulk = (BufferedBulk)((Object)bulk);
            this.metrics.batchFailed();
            int batchSize = bufferedBulk.getActions().size();
            this.metrics.itemsFailed(batchSize);
            InternalLogging.getLogger().warn(String.format("Batch of %s items failed. Redirecting to %s", batchSize, failover.getClass().getName()), new Object[0]);
            try {
                bufferedBulk.getActions().stream().map(item -> this.failedItemOps.createItem((Object)((BufferedIndex)((Object)((Object)item))))).forEach(arg_0 -> ((FailoverPolicy)failover).deliver(arg_0));
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                InternalLogging.getLogger().error("Unable to execute failover", new Object[]{e});
                Boolean bl = false;
                return bl;
            }
            finally {
                this.metrics.failoverTookMs(System.currentTimeMillis() - start);
            }
        };
    }

    @Override
    public BatchOperations<Bulk> createBatchOperations() {
        if (this.dataStreamsEnabled) {
            return new BufferedBulkOperations(this.itemSourceFactory, this.mixIns, true);
        }
        return new BufferedBulkOperations(this.itemSourceFactory, this.mixIns, this.mappingType);
    }

    @Override
    protected JestResultHandler<JestResult> createResultHandler(final Bulk bulk, final Function<Bulk, Boolean> failureHandler) {
        return new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                BufferedJestHttpObjectFactory.this.backoffPolicy.deregister((Object)bulk);
                if (result.isSucceeded()) {
                    BufferedJestHttpObjectFactory.this.metrics.itemsDelivered(BufferedJestHttpObjectFactory.this.getBatchSize(bulk));
                } else {
                    InternalLogging.getLogger().warn(result.getErrorMessage(), new Object[0]);
                    failureHandler.apply(bulk);
                }
                ((BufferedBulk)bulk).completed();
            }

            public void failed(Exception ex) {
                InternalLogging.getLogger().warn(ex.getMessage(), new Object[]{ex});
                BufferedJestHttpObjectFactory.this.backoffPolicy.deregister((Object)bulk);
                failureHandler.apply(bulk);
                ((BufferedBulk)bulk).completed();
            }
        };
    }

    @Override
    int getBatchSize(Bulk bulk) {
        return ((BufferedBulk)bulk).getActions().size();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    ClientProvider<JestClient> getClientProvider(final WrappedHttpClientConfig.Builder clientConfigBuilder) {
        return new JestHttpObjectFactory.JestClientProvider(clientConfigBuilder){

            @Override
            public JestClient createClient() {
                WrappedHttpClientConfig wrappedHttpClientConfig = clientConfigBuilder.build();
                BufferedJestClientFactory jestClientFactory = new BufferedJestClientFactory(wrappedHttpClientConfig);
                return jestClientFactory.getObject();
            }
        };
    }

    @Override
    public void register(MetricsRegistry registry) {
        super.register(registry);
        Measured.of((Object)this.itemSourceFactory).register(registry);
    }

    @Override
    public void deregister() {
        super.deregister();
        Measured.of((Object)this.itemSourceFactory).deregister();
    }

    @Override
    public void start() {
        super.start();
        if (!this.itemSourceFactory.isStarted()) {
            this.itemSourceFactory.start();
        }
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.itemSourceFactory.isStopped()) {
            this.itemSourceFactory.stop();
        }
        this.state = LifeCycle.State.STOPPED;
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public static class Builder
    extends JestHttpObjectFactory.Builder {
        @PluginElement(value="itemSourceFactory")
        protected PooledItemSourceFactory pooledItemSourceFactory;
        @PluginElement(value="jacksonMixIn")
        private JacksonMixIn[] mixIns = new JacksonMixIn[0];

        public Builder() {
            this.metricsFactory.configure(GenericItemSourcePool.metricConfigs((boolean)false));
        }

        @Override
        public BufferedJestHttpObjectFactory build() {
            this.validate();
            this.resolveLazyProperties();
            return new BufferedJestHttpObjectFactory(this);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.pooledItemSourceFactory == null) {
                throw new ConfigurationException("No PooledItemSourceFactory configured for BufferedJestHttpObjectFactory");
            }
        }

        @Override
        protected FailedItemOps<AbstractDocumentTargetedAction<DocumentResult>> failedItemOps() {
            return new BufferedHttpFailedItemOps();
        }

        public Builder withItemSourceFactory(PooledItemSourceFactory pooledItemSourceFactory) {
            this.pooledItemSourceFactory = pooledItemSourceFactory;
            return this;
        }

        public Builder withMixIns(JacksonMixIn[] mixIns) {
            this.mixIns = mixIns;
            return this;
        }
    }
}

