/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlEncodable;
import brut.androlib.res.xml.ResXmlEncoders;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ResScalarValue
extends ResIntBasedValue
implements ResXmlEncodable,
ResValuesXmlSerializable {
    protected final String mType;
    protected final String mRawValue;

    protected ResScalarValue(String type, int rawIntValue, String rawValue) {
        super(rawIntValue);
        this.mType = type;
        this.mRawValue = rawValue;
    }

    @Override
    public String encodeAsResXmlAttr() throws AndrolibException {
        if (this.mRawValue != null) {
            return this.mRawValue;
        }
        return this.encodeAsResXml();
    }

    public String encodeAsResXmlItemValue() throws AndrolibException {
        return this.encodeAsResXmlValue();
    }

    @Override
    public String encodeAsResXmlValue() throws AndrolibException {
        if (this.mRawValue != null) {
            return this.mRawValue;
        }
        return this.encodeAsResXml();
    }

    public String encodeAsResXmlNonEscapedItemValue() throws AndrolibException {
        return this.encodeAsResXmlValue().replace("&amp;", "&").replace("&lt;", "<");
    }

    public boolean hasMultipleNonPositionalSubstitutions() {
        return ResXmlEncoders.hasMultipleNonPositionalSubstitutions(this.mRawValue);
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        String type = res.getResSpec().getType().getName();
        boolean item = !"reference".equals(this.mType) && !type.equals(this.mType);
        String body = this.encodeAsResXmlValue();
        if (!type.equalsIgnoreCase("color") && body.contains("@") && !res.getFilePath().contains("string")) {
            item = true;
        }
        if (res.getResSpec().isDummyResSpec()) {
            item = true;
        }
        if (type.equalsIgnoreCase("id") && !body.isEmpty()) {
            body = "";
        }
        String tagName = item ? "item" : type;
        serializer.startTag(null, tagName);
        if (item) {
            serializer.attribute(null, "type", type);
        }
        serializer.attribute(null, "name", res.getResSpec().getName());
        this.serializeExtraXmlAttrs(serializer, res);
        if (!body.isEmpty()) {
            serializer.ignorableWhitespace(body);
        }
        serializer.endTag(null, tagName);
    }

    public String getType() {
        return this.mType;
    }

    protected void serializeExtraXmlAttrs(XmlSerializer serializer, ResResource res) throws IOException {
    }

    protected abstract String encodeAsResXml() throws AndrolibException;
}

